/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration.tree;

import oracle.bpm.designer.datadeclaration.tree.DataDeclarationContainerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationExplorerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataDeclarationScopeTreeNode
extends DataDeclarationExplorerTreeNode {
    private DataDeclarationContainerTreeNode dataDeclarationContainerTreeNode;
    private DataDeclarationScopeTreeNode dataDeclarationParentScopeTreeNode;
    private DataDeclarationContainerTreeNode predefinedContainerTreeNode;

    public DataDeclarationScopeTreeNode(Object object) {
        super(object);
    }

    public DataDeclarationScopeTreeNode(@NotNull DataDeclarationContainer dataDeclarationContainer) {
        super(dataDeclarationContainer);
    }

    public Image getIcon() {
        return ProjectObjectRenderer.Default.getIcon((ProjectObject)this.getDataDeclarationContainer());
    }

    public String getText() {
        return ProjectObjectRenderer.Default.getLabel((ProjectObject)this.getDataDeclarationContainer());
    }

    public DataDeclarationContainer getDataDeclarationContainer() {
        return (DataDeclarationContainer)this.getUserObject();
    }

    @Override
    public DataDeclarationTreeNode findDataDeclarationTreeNode(@NotNull DataDeclaration dataDeclaration) {
        return this.findDataDeclarationTreeNodeRecursive(dataDeclaration, this);
    }

    @NotNull
    public DataDeclarationContainerTreeNode getDataDeclarationContainerTreeNode() {
        if (this.dataDeclarationContainerTreeNode == null) {
            this.dataDeclarationContainerTreeNode = DataDeclarationContainerTreeNode.createDefault(this.getDataDeclarationContainer());
            this.add(this.dataDeclarationContainerTreeNode);
        }
        return this.dataDeclarationContainerTreeNode;
    }

    @NotNull
    public DataDeclarationContainerTreeNode getPredefinedContainerTreeNode() {
        if (this.predefinedContainerTreeNode == null) {
            this.predefinedContainerTreeNode = DataDeclarationContainerTreeNode.createPredefined(this.getDataDeclarationContainer());
            if (this.predefinedContainerTreeNode.hasChildren()) {
                this.add(this.predefinedContainerTreeNode);
            }
        }
        return this.predefinedContainerTreeNode;
    }

    @Nullable
    public DataDeclarationScopeTreeNode getDataDeclarationParentScopeTreeNode() {
        if (this.dataDeclarationParentScopeTreeNode == null && this.getDataDeclarationContainer().getParentScope() != null) {
            this.dataDeclarationParentScopeTreeNode = new DataDeclarationScopeTreeNode(this.getDataDeclarationContainer().getParentScope());
            this.add(this.dataDeclarationParentScopeTreeNode);
        }
        return this.dataDeclarationParentScopeTreeNode;
    }

    protected void onLoading() {
        this.buildTree();
    }

    private void buildTree() {
        this.getDataDeclarationContainerTreeNode();
        this.getPredefinedContainerTreeNode();
        this.getDataDeclarationParentScopeTreeNode();
    }

    private DataDeclarationTreeNode findDataDeclarationTreeNodeRecursive(@NotNull DataDeclaration dataDeclaration, @NotNull DataDeclarationScopeTreeNode scope) {
        DataDeclarationScopeTreeNode parentScopeTreeNode;
        DataDeclarationContainerTreeNode predefinedContainerTreeNode;
        DataDeclarationContainerTreeNode declarationsContainerTreeNode = scope.getDataDeclarationContainerTreeNode();
        DataDeclarationTreeNode result = this.findDataDeclarationTreeNode(dataDeclaration, declarationsContainerTreeNode);
        if (result == null && (result = this.findDataDeclarationTreeNode(dataDeclaration, predefinedContainerTreeNode = scope.getPredefinedContainerTreeNode())) == null && (parentScopeTreeNode = scope.getDataDeclarationParentScopeTreeNode()) != null) {
            result = this.findDataDeclarationTreeNodeRecursive(dataDeclaration, parentScopeTreeNode);
        }
        return result;
    }

    private DataDeclarationTreeNode findDataDeclarationTreeNode(@NotNull DataDeclaration dataDeclaration, @NotNull DataDeclarationContainerTreeNode containerTreeNode) {
        DataDeclarationTreeNode result = null;
        for (TreeNode childNode : containerTreeNode.getChildren()) {
            DataDeclarationTreeNode childDeclarationNode;
            DataDeclaration childDeclaration;
            if (!(childNode instanceof DataDeclarationTreeNode) || !(childDeclaration = (childDeclarationNode = (DataDeclarationTreeNode)childNode).getDataDeclaration()).getName().equals(dataDeclaration.getName()) || !childDeclaration.getType().equals(dataDeclaration.getType())) continue;
            result = childDeclarationNode;
            break;
        }
        return result;
    }
}

