/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.datadeclaration.DataDeclarationDialog;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.variables.BusinessIndicatorDialog;
import oracle.bpm.project.ProjectVariableImpl;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

class DataDeclarationEditAction
extends DesignerAction {
    private DataDeclarationTreeNode node;

    public DataDeclarationEditAction(@NotNull DataDeclarationTreeNode node) {
        this.node = node;
        this.requires(DataDeclaration.class);
        this.setMsg(UIMsg.EDIT);
    }

    @Override
    public boolean doIt() {
        ProjectVariableImpl projectVar;
        boolean result = false;
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        DataDeclarationContainer dataDeclarationContainer = dataDeclaration.getDeclarationContainer();
        Object dialog = null;
        dialog = dataDeclaration instanceof ProjectVariableImpl ? ((projectVar = (ProjectVariableImpl)dataDeclaration).isBusiness() ? new BusinessIndicatorDialog(Ui.getRoot(), ProjectUiMsg.EDIT((Msg)projectVar.getBusinessVariableType().getMsg()), (ProjectDataObject)projectVar, projectVar.getBusinessVariableType()) : DataDeclarationDialog.createForProjectDataObject(Ui.getRoot(), dataDeclaration, dataDeclarationContainer.getLocalDeclarations(), false)) : DataDeclarationDialog.createForDataObject(Ui.getRoot(), dataDeclaration, dataDeclarationContainer.getLocalDeclarations(), false);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            result = true;
        }
        return result;
    }

    private DataDeclaration getDataDeclaration() {
        return (DataDeclaration)this.getSelection().as(DataDeclaration.class);
    }
}

