/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration.tree;

import oracle.bpm.designer.datadeclaration.tree.DataDeclarationContainerAddAction;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

abstract class DataDeclarationContainerTreeNode
extends TreeNode {
    protected DataDeclarationContainerTreeNode(@NotNull DataDeclarationContainer dataDeclarationContainer) {
        super((Object)dataDeclarationContainer);
    }

    public static DataDeclarationContainerTreeNode createDefault(@NotNull DataDeclarationContainer dataDeclarationContainer) {
        return new DefaultDataDeclarationContainerTreeNode(dataDeclarationContainer);
    }

    public static DataDeclarationContainerTreeNode createPredefined(@NotNull DataDeclarationContainer dataDeclarationContainer) {
        return new PredefinedDeclarationContainerTreeNode(dataDeclarationContainer);
    }

    public Image getIcon() {
        return Image.create((Msg)UIMsg.CLOSE_FOLDER);
    }

    public DataDeclarationContainer getDataDeclarationContainer() {
        return (DataDeclarationContainer)this.getUserObject();
    }

    protected abstract void buildTree();

    protected void onLoading() {
        this.buildTree();
    }

    private static class PredefinedDeclarationContainerTreeNode
    extends DataDeclarationContainerTreeNode {
        public PredefinedDeclarationContainerTreeNode(@NotNull DataDeclarationContainer dataDeclarationContainer) {
            super(dataDeclarationContainer);
        }

        @Override
        public Image getIcon() {
            return Image.create((Msg)UIMsg.CLOSE_FOLDER);
        }

        public String getText() {
            return DesignerMsg.PREDEFINED_VARIABLES.getString();
        }

        @Override
        protected void buildTree() {
            for (DataDeclaration child : this.getDataDeclarationContainer().getLocalDeclarations()) {
                if (!child.isPredefinedDeclaration()) continue;
                DataDeclarationTreeNode childNode = new DataDeclarationTreeNode(child);
                this.add(childNode);
            }
        }
    }

    private static class DefaultDataDeclarationContainerTreeNode
    extends DataDeclarationContainerTreeNode {
        public DefaultDataDeclarationContainerTreeNode(@NotNull DataDeclarationContainer dataDeclarationContainer) {
            super(dataDeclarationContainer);
            Project project = dataDeclarationContainer.getProject();
            project.addListener((ProjectListener)new ProjectListenerAdapter<DataDeclaration>(DataDeclaration.class){

                public void postObjectAdded(DataDeclaration object, ProjectObject parent) {
                    this.reloadNode(parent);
                }

                public void postObjectRemoved(DataDeclaration object, ProjectObject parent) {
                    this.reloadNode(parent);
                }

                private void reloadNode(ProjectObject parent) {
                    if (DefaultDataDeclarationContainerTreeNode.this.getDataDeclarationContainer() == parent || DefaultDataDeclarationContainerTreeNode.this.getDataDeclarationContainer() instanceof Project && parent instanceof Process && ModelUtils.isDefaultProcess((Process)((Process)parent))) {
                        DefaultDataDeclarationContainerTreeNode.this.unload();
                        DefaultDataDeclarationContainerTreeNode.this.reload();
                    }
                }
            });
        }

        @Override
        public Image getIcon() {
            return Image.create((Msg)UIMsg.CLOSE_FOLDER);
        }

        public String getText() {
            Class rawClass = this.getDataDeclarationContainer().getRawClass();
            return Project.class.isAssignableFrom(rawClass) || Process.class.isAssignableFrom(rawClass) || Subprocess.class.isAssignableFrom(rawClass) ? ProjectMsg.DATA_OBJECTS.getString() : DesignerMsg.ARGUMENTS.getString();
        }

        public ActionGroup createActions() {
            ActionGroup result = new ActionGroup();
            if (this.getDataDeclarationContainer().isMutableDeclarationContainer()) {
                result.add((BaseAction)new DataDeclarationContainerAddAction(this));
            }
            return result;
        }

        @Override
        protected void buildTree() {
            for (DataDeclaration child : this.getDataDeclarationContainer().getLocalDeclarations()) {
                if (child.isPredefinedDeclaration()) continue;
                DataDeclarationTreeNode childNode = new DataDeclarationTreeNode(child);
                this.add(childNode);
            }
        }
    }
}

