/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.datadeclaration.DataDeclarationDialog;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationContainerTreeNode;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

class DataDeclarationContainerAddAction
extends DesignerAction {
    DataDeclarationContainerTreeNode node;
    private static final String DATA_OBJECT_DEFAULT_NAME = "dataObject";
    private static final String PROJECT_DATA_OBJECT_DEFAULT_NAME = "projectDataObject";

    public DataDeclarationContainerAddAction(@NotNull DataDeclarationContainerTreeNode node) {
        this.node = node;
        this.requires(DataDeclarationContainer.class);
        this.setMsg(UIMsg.ADD);
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        try {
            DataDeclarationContainer dataDeclarationContainer = this.getDataDeclarationContainer();
            boolean isProjectDataObject = dataDeclarationContainer.getProject() == dataDeclarationContainer;
            String defaultNameSeed = isProjectDataObject ? PROJECT_DATA_OBJECT_DEFAULT_NAME : DATA_OBJECT_DEFAULT_NAME;
            String name = DataDeclarationDialog.getDefaultDeclarationName(dataDeclarationContainer.getLocalDeclarations(), defaultNameSeed);
            CatalogType type = DataDeclarationDialog.getDefaultType();
            DataDeclaration dataDeclaration = dataDeclarationContainer.createDeclaration(name, type);
            DataDeclarationDialog dialog = isProjectDataObject ? DataDeclarationDialog.createForProjectDataObject(Ui.getRoot(), dataDeclaration, dataDeclarationContainer.getLocalDeclarations(), true) : DataDeclarationDialog.createForDataObject(Ui.getRoot(), dataDeclaration, dataDeclarationContainer.getLocalDeclarations(), true);
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                dataDeclarationContainer.addDeclaration(dataDeclaration);
                result = true;
            }
            this.node.expand();
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
        return result;
    }

    private DataDeclarationContainer getDataDeclarationContainer() {
        return (DataDeclarationContainer)this.getSelection().as(DataDeclarationContainer.class);
    }
}

