/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.TypeChooserPanel;
import oracle.bpm.designer.type.TypeChooserUseCase;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.InstanceVariable;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.InitializableDeclaration;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationDialog
extends OkCancelDialog {
    private DataDeclaration dataDeclaration;
    private Msg helpMsg;
    private IdentifierTextField idTextField;
    private CheckBox initializeCheckBox;
    private boolean isCreation;
    private boolean isEdition;
    private String oldName;
    private TypeChooserPanel typeChooserPanel;
    private Sequence<DataDeclaration> usedDeclarations;

    private DataDeclarationDialog(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations, @NotNull Msg title, @NotNull Msg helpMsg, @NotNull TypeChooserUseCase useCase, boolean create) {
        super(parent, title);
        this.dataDeclaration = dataDeclaration;
        this.usedDeclarations = usedDeclarations;
        this.helpMsg = helpMsg;
        this.isCreation = create;
        String name = dataDeclaration.getName();
        this.isEdition = DataDeclarationDialog.declarationNameExists(usedDeclarations, name);
        this.oldName = name;
        this.init(useCase);
    }

    public static DataDeclarationDialog createForDataObject(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations, boolean create) {
        Msg msg = ProjectUiMsg.DATA_OBJECT;
        Msg titleMsg = create ? ProjectUiMsg.CREATE((Msg)msg) : ProjectUiMsg.EDIT((Msg)msg);
        return new DataDeclarationDialog(parent, dataDeclaration, usedDeclarations, titleMsg, msg, TypeChooserUseCase.DATA_OBJECT_TYPES, create);
    }

    public static DataDeclarationDialog createForProjectDataObject(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations, boolean create) {
        Msg msg = ProjectUiMsg.PROJECT_DATA_OBJECT;
        Msg titleMsg = create ? ProjectUiMsg.CREATE((Msg)msg) : ProjectUiMsg.EDIT((Msg)msg);
        return new DataDeclarationDialog(parent, dataDeclaration, usedDeclarations, titleMsg, msg, TypeChooserUseCase.PROJECT_DATA_OBJECT_TYPES, create);
    }

    public static DataDeclarationDialog createForArgument(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations, boolean arraysSupported, boolean create) {
        Msg msg = DesignerMsg.ARGUMENT;
        Msg titleMsg = create ? ProjectUiMsg.CREATE((Msg)msg) : ProjectUiMsg.EDIT((Msg)msg);
        TypeChooserUseCase useCase = arraysSupported ? TypeChooserUseCase.ARGUMENT_TYPES_WITH_ARRAYS : TypeChooserUseCase.ARGUMENT_TYPES;
        return new DataDeclarationDialog(parent, dataDeclaration, usedDeclarations, titleMsg, msg, useCase, create);
    }

    public static DataDeclarationDialog createForLoopDataArgument(@NotNull UiWindow parent, @NotNull DataDeclaration dataDeclaration, @NotNull Sequence<DataDeclaration> usedDeclarations) {
        Msg msg = DesignerMsg.ARGUMENT;
        Msg titleMsg = ProjectUiMsg.CREATE((Msg)msg);
        TypeChooserUseCase useCase = TypeChooserUseCase.ARRAYS_ONLY;
        return new DataDeclarationDialog(parent, dataDeclaration, usedDeclarations, titleMsg, msg, useCase, false);
    }

    public static String getDefaultDeclarationName(@NotNull Sequence<DataDeclaration> usedDeclarations, @NotNull String defaultNameSeed) {
        int count = 1;
        while (DataDeclarationDialog.declarationNameExists(usedDeclarations, defaultNameSeed + count)) {
            ++count;
        }
        return defaultNameSeed + count;
    }

    public static CatalogType getDefaultType() {
        return CatalogType.Default.getString();
    }

    public String getHelpId() {
        return this.getHelpIdWithMsg() + "." + this.helpMsg.getCode();
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        DataDeclarationDialog.updateDataDeclaration(this.dataDeclaration, this.idTextField.getText(), this.typeChooserPanel.getCatalogType(), this.isCreation);
        if (this.isInitializable()) {
            InitializableDeclaration initializableDeclaration = (InitializableDeclaration)this.dataDeclaration;
            initializableDeclaration.setInitialize(this.initializeCheckBox.isSelected());
        }
        this.close();
    }

    private static void updateDataDeclaration(DataDeclaration dataDeclaration, String text, CatalogType catalogType, boolean creation) {
        if (dataDeclaration instanceof InstanceVariable) {
            ((InstanceVariable)dataDeclaration).update(text, catalogType, creation);
        } else {
            dataDeclaration.setName(text);
            dataDeclaration.setType(catalogType);
        }
    }

    private static boolean declarationNameExists(@NotNull Sequence<DataDeclaration> declarations, @NotNull String name) {
        for (DataDeclaration dataDeclaration : declarations) {
            if (!dataDeclaration.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Msg validateInput() {
        String name = this.idTextField.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.DECLARATION_NAME_IS_NULL(this.helpMsg.getString());
        }
        if (!this.isEdition || !name.equals(this.oldName)) {
            try {
                if (DataDeclarationDialog.declarationNameExists(this.usedDeclarations, name)) {
                    return DesignerMsg.DECLARATION_ALREADY_DEFINED(this.helpMsg.getString(), name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.typeChooserPanel.isValidType()) {
            return DesignerMsg.NO_TYPE;
        }
        return null;
    }

    private void init(@NotNull TypeChooserUseCase useCase) {
        UiContainer contentPane = this.getContentPane();
        Panel panel = new Panel(contentPane);
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.idTextField = new IdentifierTextField((UiContainer)panel, 30, true);
        this.idTextField.setTextLimit(30);
        this.idTextField.setText(this.dataDeclaration.getName());
        Project project = this.dataDeclaration.getProject();
        this.typeChooserPanel = TypeChooserPanel.create((UiContainer)panel, project, useCase);
        this.typeChooserPanel.setCatalogType(this.dataDeclaration.getType());
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME));
        panel.add((UiComponent)this.idTextField, (Object)"growx, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CoreMsg.TYPE), (Object)"top");
        panel.add((UiComponent)this.typeChooserPanel, (Object)"growx, wrap");
        if (this.isInitializable()) {
            Panel initPanel = new Panel(contentPane);
            initPanel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
            InitializableDeclaration initializableDeclaration = (InitializableDeclaration)this.dataDeclaration;
            this.initializeCheckBox = CheckBox.create((UiContainer)initPanel, (Msg)DesignerMsg.AUTO_INITIALIZE, (boolean)initializableDeclaration.isInitialize());
            initPanel.add((UiComponent)this.initializeCheckBox, (Object)"spanx 2, wrap");
            contentPane.add((UiComponent)initPanel, (Object)"South");
        }
        contentPane.add((UiComponent)panel, (Object)"Center");
        this.pack();
        this.setSize(400, 180);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private boolean isInitializable() {
        return this.dataDeclaration instanceof InitializableDeclaration;
    }
}

