/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.correlation.CorrelationPropertyDialog;
import oracle.bpm.designer.correlation.CorrelationPropertyExpressionsCache;
import oracle.bpm.designer.correlation.CorrelationPropertyRetrievalExpressionsPanel;
import oracle.bpm.designer.correlation.CorrelationsPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.AddCorrelationKeyCommand;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class SimpleCorrelationsPanel
extends CorrelationsPanel {
    private CorrelationPropertyExpressionsCache cacheModel;
    private CorrelationItemsContainer container;
    private CheckBox initiatesCheckBox;
    private ReferenceComboBox<CorrelationProperty> propertyComboBox;
    private CorrelationPropertyRetrievalExpressionsPanel retrievalExpressionsPanel;

    public SimpleCorrelationsPanel(@NotNull UiContainer parent, @NotNull CorrelationItemsContainer container, @NotNull CorrelationPropertyExpressionsCache cacheModel) {
        super(parent);
        this.container = container;
        this.cacheModel = cacheModel;
        this.init();
    }

    public static boolean isSimpleCorrelationContainer(@NotNull CorrelationItemsContainer container) {
        return container.getCorrelationItems().isEmpty() || SimpleCorrelationsPanel.getSingleProperty(container) != null;
    }

    @Override
    void applyChanges() {
        try {
            CorrelationProperty selectedProperty = (CorrelationProperty)this.propertyComboBox.getSelectedItem();
            if (selectedProperty != null) {
                CorrelationProperty singleProperty;
                Sequence properties;
                String propertyName;
                String correlationKeyName;
                boolean correlationKeyExists = false;
                CorrelationKeyContainer processCorrelationKeyContainer = this.getProcessCorrelationKeyContainer(this.container);
                CorrelationKey correlationKey = processCorrelationKeyContainer.findCorrelationKey(correlationKeyName = SimpleCorrelationsPanel.getCorrelationKeySimpleName(propertyName = selectedProperty.getName()));
                if (correlationKey != null && (properties = correlationKey.getProperties()).toArray().length == 1 && (singleProperty = (CorrelationProperty)properties.iterator().next()) == selectedProperty) {
                    correlationKeyExists = true;
                }
                if (!correlationKeyExists) {
                    correlationKey = processCorrelationKeyContainer.createCorrelationKey(correlationKeyName);
                    correlationKey.addProperty(selectedProperty);
                    ActionRunner.getInstance().run((Command)new AddCorrelationKeyCommand(processCorrelationKeyContainer, correlationKey));
                }
                this.container.clearCorrelationItems();
                CorrelationItem correlationItem = this.container.createCorrelationItem(correlationKey, this.initiatesCheckBox.isSelected());
                this.container.addCorrelationItem(correlationItem);
                Project project = this.container.getProject();
                Sequence<CorrelationKey> selectedKeys = CollectionUtils.singletonSequence(correlationKey);
                Sequence<CorrelationPropertyAlias> propertyAliases = this.cacheModel.buildPropertyAliases(this.container, selectedKeys);
                for (CorrelationPropertyAlias propertyAlias : propertyAliases) {
                    project.setPropertyAlias(propertyAlias);
                }
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    @Override
    Msg validateInput() {
        CorrelationProperty property = (CorrelationProperty)this.propertyComboBox.getSelectedItem();
        if (property != null) {
            String propertyName;
            String correlationKeyName;
            if (property.isUnknownProperty()) {
                return DesignerMsg.DYNAMIC_SELECTION_INVALID(DesignerMsg.CORRELATION_PROPERTY);
            }
            if (this.retrievalExpressionsPanel.hasEmptyExpressions()) {
                return DesignerMsg.DYNAMIC_ONE_OR_MORE_NULL(DesignerMsg.CORRELATION_PROPERTY_ALIAS);
            }
            if (this.retrievalExpressionsPanel.hasInvalidExpressions()) {
                return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.CORRELATION_PROPERTY_ALIAS);
            }
            CorrelationKeyContainer processCorrelationKeyContainer = this.getProcessCorrelationKeyContainer(this.container);
            CorrelationKey correlationKey = processCorrelationKeyContainer.findCorrelationKey(correlationKeyName = SimpleCorrelationsPanel.getCorrelationKeySimpleName(propertyName = property.getName()));
            if (correlationKey != null) {
                Sequence properties = correlationKey.getProperties();
                if (properties.toArray().length == 1) {
                    CorrelationProperty singleProperty = (CorrelationProperty)properties.iterator().next();
                    if (singleProperty != property) {
                        return DesignerMsg.INVALID_SIMPLE_CORRELATION_KEY_INVALID_PROPERTY;
                    }
                } else {
                    return DesignerMsg.INVALID_SIMPLE_CORRELATION_KEY_MULTIPLE_PROPERTIES;
                }
            }
        }
        return null;
    }

    private static CorrelationProperty getSingleProperty(@NotNull CorrelationItemsContainer container) {
        CorrelationProperty result = null;
        CorrelationItem singleItem = SimpleCorrelationsPanel.getSingleItem(container);
        if (singleItem != null) {
            CorrelationKey correlationKey = singleItem.getCorrelationKey();
            Sequence properties = correlationKey.getProperties();
            result = (CorrelationProperty)properties.iterator().next();
        }
        return result;
    }

    private static CorrelationItem getSingleItem(@NotNull CorrelationItemsContainer container) {
        Sequence properties;
        CorrelationItem correlationItem;
        CorrelationKey correlationKey;
        CorrelationItem result = null;
        Sequence items = container.getCorrelationItems();
        if (items.toArray().length == 1 && Process.class.isAssignableFrom((correlationKey = (correlationItem = (CorrelationItem)items.iterator().next()).getCorrelationKey()).getParentObject().getRawClass()) && (properties = correlationKey.getProperties()).toArray().length == 1) {
            CorrelationProperty property = (CorrelationProperty)properties.iterator().next();
            String correlationKeyName = SimpleCorrelationsPanel.getCorrelationKeySimpleName(property.getName());
            if (correlationKey.getName().equals(correlationKeyName)) {
                result = (CorrelationItem)items.iterator().next();
            }
        }
        return result;
    }

    private static String getCorrelationKeySimpleName(@NotNull String propertyName) {
        return "ck_" + propertyName;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, fill"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROPERTY));
        this.propertyComboBox = this.createCorrelationPropertyComboBox((UiContainer)this);
        this.add((UiComponent)this.propertyComboBox, "growx, pushx");
        this.updatePropertyComboBox();
        Button newPropertyButton = Button.createIconic((UiContainer)this, (Msg)DesignerMsg.NEW_CORRELATION_PROPERTY);
        newPropertyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Project project = SimpleCorrelationsPanel.this.container.getProject();
                CorrelationPropertyDialog dialog = new CorrelationPropertyDialog(Ui.getRoot(), project, null);
                if (dialog.display()) {
                    try {
                        CorrelationProperty newCorrelationProperty = (CorrelationProperty)dialog.getObject();
                        project.setProperty(newCorrelationProperty);
                        SimpleCorrelationsPanel.this.updatePropertyComboBox();
                        SimpleCorrelationsPanel.this.propertyComboBox.setSelectedItem((Object)newCorrelationProperty);
                    }
                    catch (ProjectException ex) {
                        MessageDialog.showError((Throwable)ex);
                    }
                }
            }
        });
        this.add((UiComponent)newPropertyButton, "wrap");
        CorrelationProperty singleProperty = SimpleCorrelationsPanel.getSingleProperty(this.container);
        this.propertyComboBox.setSelectedItem((Object)singleProperty);
        this.initiatesCheckBox = new CheckBox((UiContainer)this);
        this.initiatesCheckBox.setMsg(DesignerMsg.INITIATES);
        this.initiatesCheckBox.setSelected(SimpleCorrelationsPanel.getSingleItem(this.container) != null && SimpleCorrelationsPanel.getSingleItem(this.container).initiates());
        this.add((UiComponent)this.initiatesCheckBox, "skip 1, wrap");
        this.rebuildRetrievalExpressionsPanel();
    }

    private void updatePropertyComboBox() {
        Sequence properties = this.container.getProject().getProperties();
        this.propertyComboBox.removeAllItems();
        for (CorrelationProperty property : properties) {
            this.propertyComboBox.addItem((Object)property);
        }
    }

    private void rebuildRetrievalExpressionsPanel() {
        CorrelationProperty property;
        if (this.retrievalExpressionsPanel != null) {
            this.retrievalExpressionsPanel.dispose();
            this.retrievalExpressionsPanel.getParent().remove((UiComponent)this.retrievalExpressionsPanel);
        }
        Sequence<CorrelationProperty> propertySeq = (property = (CorrelationProperty)this.propertyComboBox.getSelectedItem()) != null ? CollectionUtils.singletonSequence(property) : CollectionUtils.emptySequence();
        this.retrievalExpressionsPanel = new CorrelationPropertyRetrievalExpressionsPanel((UiContainer)this, this.container, propertySeq, this.cacheModel);
        this.add((UiComponent)this.retrievalExpressionsPanel, "spanx, grow");
        this.revalidate();
    }

    private ReferenceComboBox<CorrelationProperty> createCorrelationPropertyComboBox(@NotNull UiContainer container) {
        final ReferenceComboBox result = new ReferenceComboBox(container);
        LabelProvider.Default<CorrelationProperty> labelProvider = new LabelProvider.Default<CorrelationProperty>(){

            public String getText(CorrelationProperty element) {
                return element != null ? element.getName() : DesignerMsg.REQUIRED_COMBOBOX_NULL_LABEL.getString();
            }

            public Image getIcon(CorrelationProperty element) {
                return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
            }
        };
        result.setLabelProvider((LabelProvider)labelProvider);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    CorrelationProperty property = (CorrelationProperty)result.getSelectedItem();
                    String tooltipText = property != null ? property.getFullName().toString() : null;
                    result.setToolTipText(tooltipText);
                    SimpleCorrelationsPanel.this.rebuildRetrievalExpressionsPanel();
                }
            }
        });
        return result;
    }

    private CorrelationKeyContainer getProcessCorrelationKeyContainer(@NotNull CorrelationItemsContainer root) {
        for (CorrelationItemsContainer container = root; container != null; container = container.getParentObject()) {
            if (!Process.class.isAssignableFrom(container.getRawClass())) continue;
            return (CorrelationKeyContainer)container;
        }
        return null;
    }
}

