/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import oracle.bpm.designer.correlation.AdvancedCorrelationsPanel;
import oracle.bpm.designer.correlation.CorrelationPropertyExpressionsCache;
import oracle.bpm.designer.correlation.CorrelationsPanel;
import oracle.bpm.designer.correlation.SimpleCorrelationsPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class CorrelationsContainerPanel
extends CorrelationsPanel {
    private CorrelationPropertyExpressionsCache cacheModel;
    private CardLayout cardLayout;
    private CorrelationItemsContainer correlationItemsContainer;
    private Panel delegateContainer;
    private CorrelationsContainerPanelMode mode;
    private Link switchModeLink;

    public CorrelationsContainerPanel(@NotNull UiContainer parent, @NotNull CorrelationItemsContainer correlationItemsContainer, @NotNull CorrelationPropertyExpressionsCache cacheModel) {
        super(parent);
        this.correlationItemsContainer = correlationItemsContainer;
        this.cacheModel = cacheModel;
        this.init();
    }

    @Override
    void applyChanges() {
        this.getDelegate().applyChanges();
    }

    @Override
    Msg validateInput() {
        return this.getDelegate().validateInput();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.delegateContainer = new Panel((UiContainer)this);
        this.cardLayout = new CardLayout();
        this.delegateContainer.setLayout((Layout)this.cardLayout);
        this.add((UiComponent)this.delegateContainer, "grow, wrap");
        SimpleCorrelationsPanel simplePanel = new SimpleCorrelationsPanel((UiContainer)this.delegateContainer, this.correlationItemsContainer, this.cacheModel);
        AdvancedCorrelationsPanel advancedPanel = new AdvancedCorrelationsPanel((UiContainer)this.delegateContainer, this.correlationItemsContainer, this.cacheModel);
        this.delegateContainer.add((UiComponent)simplePanel, (Object)CorrelationsContainerPanelMode.SIMPLE.name());
        this.delegateContainer.add((UiComponent)advancedPanel, (Object)CorrelationsContainerPanelMode.ADVANCED.name());
        this.switchModeLink = new Link((UiContainer)this);
        this.add((UiComponent)this.switchModeLink);
        this.mode = this.getCorrelationsContainerPanelMode(this.correlationItemsContainer);
        this.switchMode(this.mode);
    }

    private CorrelationsPanel getDelegate() {
        return (CorrelationsPanel)this.cardLayout.getComponent(this.mode.name());
    }

    private void switchMode(final @NotNull CorrelationsContainerPanelMode mode) {
        this.mode = mode;
        this.cardLayout.show((UiContainer)this.delegateContainer, mode.name());
        Msg linkMsg = mode == CorrelationsContainerPanelMode.SIMPLE ? DesignerMsg.SWITCH_TO_ADVANCED_MODE : DesignerMsg.SWITCH_TO_SIMPLE_MODE;
        this.switchModeLink.setAction(new BaseAction(linkMsg){

            public void run() {
                if (mode == CorrelationsContainerPanelMode.SIMPLE) {
                    CorrelationsContainerPanel.this.switchMode(CorrelationsContainerPanelMode.ADVANCED);
                } else {
                    CorrelationsContainerPanel.this.switchMode(CorrelationsContainerPanelMode.SIMPLE);
                }
            }
        });
    }

    private CorrelationsContainerPanelMode getCorrelationsContainerPanelMode(CorrelationItemsContainer container) {
        return SimpleCorrelationsPanel.isSimpleCorrelationContainer(container) ? CorrelationsContainerPanelMode.SIMPLE : CorrelationsContainerPanelMode.ADVANCED;
    }

    public static enum CorrelationsContainerPanelMode {
        SIMPLE,
        ADVANCED;

    }
}

