/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.correlation.CorrelationPropertyExpressionsCache;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Any;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CorrelationPropertyRetrievalExpressionsPanel
extends ScrollPane {
    private List<CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheListener> cacheListeners = new ArrayList<CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheListener>();
    private CorrelationPropertyExpressionsCache cacheModel;
    private List<ExpressionPanel> expressionPanels = new ArrayList<ExpressionPanel>();
    private boolean hasUnknownProperties = false;
    private Sequence<CorrelationProperty> properties;

    public CorrelationPropertyRetrievalExpressionsPanel(@NotNull UiContainer parent, @NotNull CorrelationItemsContainer correlationItemsContainer, @NotNull Sequence<CorrelationProperty> properties, @NotNull CorrelationPropertyExpressionsCache cacheModel) {
        super(parent, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
        this.properties = properties;
        this.cacheModel = cacheModel;
        this.init(correlationItemsContainer);
    }

    public boolean hasInvalidExpressions() {
        for (ExpressionPanel expressionPanel : this.expressionPanels) {
            if (expressionPanel.isExpressionValid()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmptyExpressions() {
        for (ExpressionPanel expressionPanel : this.expressionPanels) {
            if (expressionPanel.getExpression() != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnknownProperties() {
        return this.hasUnknownProperties;
    }

    public void dispose() {
        for (CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheListener cacheListener : this.cacheListeners) {
            this.cacheModel.removeListener(cacheListener);
        }
    }

    private void init(@NotNull CorrelationItemsContainer correlationItemsContainer) {
        Sequence partNames = correlationItemsContainer.getPartNames();
        boolean isSingleAlias = this.properties.toArray().length == 1 && partNames.toArray().length == 1;
        Panel contentPanel = new Panel((UiContainer)this);
        String constraints = "ins 5, gap 5, fillx";
        contentPanel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        if (!this.properties.isEmpty()) {
            for (CorrelationProperty property : this.properties) {
                boolean mustDisplayPartName = partNames.toArray().length > 1;
                for (String partName : partNames) {
                    if (property.isUnknownProperty()) {
                        this.addUnknownCorrelationProperty((UiContainer)contentPanel, property, partName, mustDisplayPartName);
                        this.hasUnknownProperties = true;
                        continue;
                    }
                    this.addCorrelationPropertyRetrievalExpressionPanel((UiContainer)contentPanel, this.expressionPanels, correlationItemsContainer, this.cacheModel, property, partName, mustDisplayPartName, isSingleAlias);
                }
            }
        } else {
            Label label = Label.createWithNoColon((UiContainer)contentPanel, (Msg)DesignerMsg.NO_CORRELATION_PROPERTY_ALIASES);
            contentPanel.add((UiComponent)label, (Object)"gapy 15, alignx center");
        }
        this.setView((UiComponent)contentPanel);
        this.setBorder((Border)new TitledBorder(DesignerMsg.CORRELATION_PROPERTY_ALIASES));
    }

    private void addUnknownCorrelationProperty(@NotNull UiContainer contentPanel, @NotNull CorrelationProperty property, @Nullable String partName, boolean mustShowPartName) {
        Label label = this.createPropertyLabel(contentPanel, property, partName, mustShowPartName);
        contentPanel.add((UiComponent)label);
        Label unknownLabel = Label.createWithNoColon((UiContainer)contentPanel, (Msg)DesignerMsg.UNKNOWN_CORRELATION_PROPERTY);
        unknownLabel.setForeground(Color.RED);
        contentPanel.add((UiComponent)unknownLabel, (Object)"gapx 5, growx, wrap");
    }

    private void addCorrelationPropertyRetrievalExpressionPanel(@NotNull UiContainer contentPanel, @NotNull List<ExpressionPanel> expressionPanels, final @NotNull CorrelationItemsContainer correlationItemsContainer, final @NotNull CorrelationPropertyExpressionsCache cacheModel, final @NotNull CorrelationProperty property, final @Nullable String partName, boolean mustDisplayPartName, boolean isSingleAlias) {
        Label label = this.createPropertyLabel(contentPanel, property, partName, mustDisplayPartName);
        String labelConstraints = isSingleAlias ? "gapy 5, aligny top" : "";
        contentPanel.add((UiComponent)label, (Object)labelConstraints);
        DataDeclarationContainer context = correlationItemsContainer.getExpressionContext(partName);
        CatalogType resultType = property.getType();
        final ExpressionPanel expressionPanel = ExpressionPanelFactory.createCorrelationPropertyAliasPanel(contentPanel, new ExpressionContext(context, resultType), isSingleAlias);
        String constraints = "growx, wrap" + (isSingleAlias ? ", pushy, growy" : "");
        contentPanel.add(expressionPanel.getUiComponent(), (Object)constraints);
        final ExpressionContainerListener expressionListener = new ExpressionContainerListener(){

            @Override
            public void expressionChanged() {
                cacheModel.putExpression(correlationItemsContainer, property, partName, expressionPanel.getExpression());
            }
        };
        expressionPanel.addListener(expressionListener);
        CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheListener cacheListener = new CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheListener(){

            @Override
            public void propertyExpressionChanged(@NotNull CorrelationPropertyExpressionsCache.CorrelationPropertyExpressionsCacheKey key, @Nullable Expression expression) {
                if (key.getProperty().equals(property) && Any.equals(key.getNativePartName(), correlationItemsContainer.getNativePartName(partName))) {
                    expressionPanel.removeListener(expressionListener);
                    expressionPanel.setExpression(expression);
                    expressionPanel.addListener(expressionListener);
                }
            }
        };
        cacheModel.addListener(cacheListener);
        this.cacheListeners.add(cacheListener);
        Expression expression = null;
        boolean isReadOnly = false;
        Expression cachedExpression = cacheModel.getExpression(correlationItemsContainer, property, partName);
        if (cachedExpression != null) {
            expression = cachedExpression;
        } else {
            CorrelationPropertyAlias propertyAlias = correlationItemsContainer.getProject().findPropertyAlias(property, partName, correlationItemsContainer.isInputsContainer(), correlationItemsContainer.getParentObject());
            if (propertyAlias != null) {
                expression = propertyAlias.getExpression();
                isReadOnly = propertyAlias.isReadOnly();
            }
        }
        expressionPanel.setExpression(expression);
        expressionPanel.setEnabled(!isReadOnly);
        expressionPanels.add(expressionPanel);
    }

    private Label createPropertyLabel(@NotNull UiContainer contentPanel, @NotNull CorrelationProperty property, @Nullable String partName, boolean mustShowPartName) {
        String labelText = property.getName();
        if (mustShowPartName) {
            labelText = labelText + "(" + partName + ")";
        }
        Label result = Label.create((UiContainer)contentPanel, (Msg)Msg.QUOTE(labelText));
        result.setToolTipText(property.getFullName().toString());
        return result;
    }
}

