/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.process.CorrelationHelper;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CorrelationPropertyExpressionsCache {
    private ArrayList<CorrelationPropertyExpressionsCacheListener> listeners = new ArrayList();
    private HashMap<CorrelationPropertyExpressionsCacheKey, Expression> map = new HashMap();

    CorrelationPropertyExpressionsCache() {
    }

    public void putExpression(@NotNull CorrelationItemsContainer correlationItemsContainer, @NotNull CorrelationProperty property, @Nullable String partName, @NotNull Expression expression) {
        CorrelationPropertyExpressionsCacheKey key = new CorrelationPropertyExpressionsCacheKey(property, correlationItemsContainer.getNativePartName(partName), partName);
        Expression mappedExpression = this.map.get(key);
        if (mappedExpression != null && mappedExpression.equals(expression)) {
            return;
        }
        this.map.put(key, expression);
        this.firePropertyExpressionChanged(key, expression);
    }

    public Expression getExpression(@NotNull CorrelationItemsContainer correlationItemsContainer, @NotNull CorrelationProperty property, @Nullable String partName) {
        CorrelationPropertyExpressionsCacheKey key = new CorrelationPropertyExpressionsCacheKey(property, correlationItemsContainer.getNativePartName(partName), partName);
        return this.map.get(key);
    }

    public Sequence<CorrelationPropertyAlias> buildPropertyAliases(@NotNull CorrelationItemsContainer correlationItemsContainer, @NotNull Sequence<CorrelationKey> correlationKeys) {
        ArrayList<CorrelationPropertyAlias> result = new ArrayList<CorrelationPropertyAlias>();
        Sequence properties = CorrelationHelper.getPropertiesUnion(correlationKeys);
        for (CorrelationPropertyExpressionsCacheKey key : this.map.keySet()) {
            if (!properties.contains(key.getProperty())) continue;
            CorrelationProperty property = key.getProperty();
            Project project = correlationItemsContainer.getProject();
            Expression expression = this.map.get(key);
            CorrelationPropertyAlias correlationPropertyAlias = project.createPropertyAlias(property, key.getPartName(), correlationItemsContainer.isInputsContainer(), correlationItemsContainer.getParentObject(), expression);
            result.add(correlationPropertyAlias);
        }
        return CollectionUtils.asSequence(result);
    }

    public void addListener(@NotNull CorrelationPropertyExpressionsCacheListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull CorrelationPropertyExpressionsCacheListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyExpressionChanged(@NotNull CorrelationPropertyExpressionsCacheKey key, @Nullable Expression expression) {
        for (CorrelationPropertyExpressionsCacheListener listener : this.listeners) {
            listener.propertyExpressionChanged(key, expression);
        }
    }

    public static class CorrelationPropertyExpressionsCacheKey {
        private String nativePartName;
        private String partName;
        private CorrelationProperty property;

        public CorrelationPropertyExpressionsCacheKey(@NotNull CorrelationProperty property, @Nullable String nativePartName, @Nullable String partName) {
            this.property = property;
            this.nativePartName = nativePartName;
            this.partName = partName;
        }

        public CorrelationProperty getProperty() {
            return this.property;
        }

        public String getNativePartName() {
            return this.nativePartName;
        }

        public String getPartName() {
            return this.partName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CorrelationPropertyExpressionsCacheKey)) {
                return false;
            }
            CorrelationPropertyExpressionsCacheKey that = (CorrelationPropertyExpressionsCacheKey)o;
            return this.nativePartName != null ? this.nativePartName.equals(that.nativePartName) : that.nativePartName == null && this.property.equals(that.property);
        }

        public int hashCode() {
            int result = this.nativePartName != null ? this.nativePartName.hashCode() : 0;
            result = 31 * result + this.property.hashCode();
            return result;
        }
    }

    public static interface CorrelationPropertyExpressionsCacheListener {
        public void propertyExpressionChanged(@NotNull CorrelationPropertyExpressionsCacheKey var1, @Nullable Expression var2);
    }
}

