/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.TypeChooserPanel;
import oracle.bpm.designer.type.TypeChooserUseCase;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationPropertyDialog
extends ObjectEditorDialog<CorrelationProperty> {
    private IdentifierTextField idTextField;
    private Project propertiesContainer;
    private TypeChooserPanel typeChooserPanel;
    private static String DEFAULT_NAME = "property";

    public CorrelationPropertyDialog(@NotNull UiWindow parent, @NotNull Project propertiesContainer, @Nullable CorrelationProperty property) {
        super(parent, DesignerMsg.CORRELATION_PROPERTY, (Object)property);
        this.propertiesContainer = propertiesContainer;
    }

    protected Msg validateInput() {
        String name = this.idTextField.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.NAME);
        }
        if ((this.isNew() || !name.equals(((CorrelationProperty)this.getObject()).getName())) && CorrelationPropertyDialog.propertyNameExists(this.propertiesContainer, name)) {
            return DesignerMsg.DYNAMIC_ALREADY_DEFINED(DesignerMsg.CORRELATION_PROPERTY);
        }
        return null;
    }

    protected void setObjectFromEditor(@NotNull CorrelationProperty object) {
        throw new UnsupportedOperationException("Cannot edit a correlation property. Must delete and create a new one");
    }

    protected boolean mustCreateAlways() {
        return true;
    }

    protected CorrelationProperty createObjectFromEditor() {
        String name = this.idTextField.getText();
        CatalogType type = this.typeChooserPanel.getCatalogType();
        return this.propertiesContainer.createCorrelationProperty(name, type);
    }

    protected void setEditorFromObject(@NotNull CorrelationProperty object) {
        this.idTextField.setText(object.getName());
        this.typeChooserPanel.setCatalogType(object.getType());
    }

    protected void setEditorDefaultValues() {
        this.idTextField.setText(this.getDefaultPropertyName(this.propertiesContainer));
        this.typeChooserPanel.setCatalogType(CatalogType.Default.getString());
    }

    protected void layoutControls(@NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.idTextField = new IdentifierTextField(container, 30, true);
        this.idTextField.setTextLimit(30);
        this.typeChooserPanel = TypeChooserPanel.create(container, this.propertiesContainer, TypeChooserUseCase.PROJECT_DATA_OBJECT_TYPES);
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectDrawMsg.NAME));
        container.add((UiComponent)this.idTextField, (Object)"growx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)CoreMsg.TYPE));
        container.add((UiComponent)this.typeChooserPanel, (Object)"growx");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private static boolean propertyNameExists(@NotNull Project container, @NotNull String name) {
        return container.findProperty(name) != null;
    }

    private String getDefaultPropertyName(Project project) {
        int count = 1;
        String varName = DEFAULT_NAME;
        while (project.findProperty(varName + count) != null) {
            ++count;
        }
        return varName + count;
    }
}

