/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.correlation.CorrelationPropertyDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListPicker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorrelationKeyDialog
extends ObjectEditorDialog<CorrelationKey> {
    private CorrelationKeyContainer container;
    private IdentifierTextField idTextField;
    private ListPicker<CorrelationProperty> propertiesListPicker;
    private static String DEFAULT_NAME = "correlationKey";

    public CorrelationKeyDialog(@NotNull UiWindow parent, @NotNull CorrelationKeyContainer container, @Nullable CorrelationKey key) {
        super(parent, DesignerMsg.CORRELATION_KEY, (Object)key);
        this.container = container;
    }

    protected Msg validateInput() {
        String name = this.idTextField.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.NAME);
        }
        if ((this.isNew() || !name.equals(((CorrelationKey)this.getObject()).getName())) && this.keyNameExists(this.container, name)) {
            return DesignerMsg.DYNAMIC_ALREADY_DEFINED(DesignerMsg.CORRELATION_KEY);
        }
        if (this.propertiesListPicker.getSelectedItems().isEmpty()) {
            return DesignerMsg.DYNAMIC_AT_LEAST_ONE_SELECTED(DesignerMsg.CORRELATION_PROPERTY);
        }
        if (this.propertiesListPicker.hasInvalidSelection()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(ProjectMsg.CORRELATION_PROPERTIES);
        }
        return null;
    }

    protected void setObjectFromEditor(@NotNull CorrelationKey object) {
        object.setName(this.idTextField.getText().trim());
        this.addPropertiesFromEditor(object);
    }

    protected CorrelationKey createObjectFromEditor() {
        CorrelationKey result = this.container.createCorrelationKey(this.idTextField.getText().trim());
        this.addPropertiesFromEditor(result);
        return result;
    }

    protected void setEditorFromObject(@NotNull CorrelationKey object) {
        this.idTextField.setText(object.getName());
        List selectedPropertiesList = CollectionUtils.toList(object.getProperties());
        this.propertiesListPicker.setSelectedItems(selectedPropertiesList);
    }

    protected void setEditorDefaultValues() {
        this.idTextField.setText(this.getDefaultKeyName(this.container));
    }

    protected void layoutControls(@NotNull UiContainer contentPane) {
        contentPane.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        this.idTextField = new IdentifierTextField(contentPane, 30, true);
        this.idTextField.setTextLimit(30);
        this.propertiesListPicker = new ListPicker(contentPane, ProjectMsg.CORRELATION_PROPERTIES);
        this.propertiesListPicker.addCustomAction(new BaseAction(UIMsg.NEW){

            public void run() {
                Project project = CorrelationKeyDialog.this.getProject();
                CorrelationPropertyDialog dialog = new CorrelationPropertyDialog(Ui.getRoot(), project, null);
                if (dialog.display()) {
                    try {
                        CorrelationProperty newCorrelationProperty = (CorrelationProperty)dialog.getObject();
                        project.setProperty(newCorrelationProperty);
                        CorrelationKeyDialog.this.updatePropertiesList();
                        CorrelationKeyDialog.this.propertiesListPicker.setAvailableItemSelected((Object)newCorrelationProperty);
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                }
            }
        });
        this.updatePropertiesList();
        final CheckBox displayFullNameCheckBox = new CheckBox(contentPane);
        displayFullNameCheckBox.setMsg(DesignerMsg.DISPLAY_CORRELATION_PROPERTY_FULL_NAME);
        displayFullNameCheckBox.setSelected(false);
        displayFullNameCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CorrelationKeyDialog.this.propertiesListPicker.repaint();
            }
        });
        this.propertiesListPicker.setLabelProvider((LabelProvider)new LabelProvider<CorrelationProperty>(){

            public Image getIcon(CorrelationProperty property) {
                return !property.isUnknownProperty() ? ProjectObjectRenderer.Default.getIcon((ProjectObject)property) : null;
            }

            public String getText(CorrelationProperty property) {
                return displayFullNameCheckBox.isSelected() ? property.getFullName().toString() : property.getName();
            }
        });
        contentPane.add((UiComponent)Label.create((UiContainer)contentPane, (Msg)ProjectDrawMsg.NAME));
        contentPane.add((UiComponent)this.idTextField, (Object)"pushx, wrap");
        contentPane.add(this.propertiesListPicker, (Object)"spanx, grow");
        contentPane.add((UiComponent)displayFullNameCheckBox, (Object)"spanx");
        this.setSize(500, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private Project getProject() {
        return this.container.getProject();
    }

    private void updatePropertiesList() {
        List propertiesList = CollectionUtils.toList(this.getProject().getProperties());
        this.propertiesListPicker.setItems(propertiesList);
    }

    private void addPropertiesFromEditor(@NotNull CorrelationKey correlationKey) {
        correlationKey.clearProperties();
        for (CorrelationProperty property : this.propertiesListPicker.getSelectedItems()) {
            try {
                correlationKey.addProperty(property);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private String getDefaultKeyName(CorrelationKeyContainer container) {
        int count = 1;
        String varName = DEFAULT_NAME;
        while (container.findCorrelationKey(varName + count) != null) {
            ++count;
        }
        return varName + count;
    }

    private boolean keyNameExists(@NotNull CorrelationKeyContainer container, @NotNull String name) {
        return container.findCorrelationKey(name) != null;
    }
}

