/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.correlation.CorrelationItemDialog;
import oracle.bpm.designer.correlation.CorrelationItemsTableModel;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

class CorrelationItemsTable
extends BaseTablePanel {
    private CorrelationItemsContainer correlationItemsContainer;

    public CorrelationItemsTable(@NotNull UiContainer parent, @NotNull CorrelationItemsContainer correlationItemsContainer) {
        super(parent, Msg.QUOTE(""), ProjectMsg.CORRELATION_KEYS, (TableModel)new CorrelationItemsTableModel(), BaseTablePanel.Style.TOOLBAR_TOP);
        this.correlationItemsContainer = correlationItemsContainer;
        this.setWithColons(true);
        this.init();
    }

    public Sequence<CorrelationItem> getCorrelationItems() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        CorrelationItemDialog dialog = new CorrelationItemDialog(this.getOwnerWindow(), null, this.correlationItemsContainer, this.getModel());
        if (dialog.display()) {
            CorrelationItem correlationItem = (CorrelationItem)dialog.getObject();
            this.getModel().addRow(correlationItem);
        }
        this.getModel().fireTableDataChanged();
    }

    protected void editAction() {
        CorrelationItem item = (CorrelationItem)this.getModel().getRow(this.getTable().getSelectedRow());
        CorrelationItemDialog dialog = new CorrelationItemDialog(Ui.getRoot(), item, this.correlationItemsContainer, this.getModel());
        if (dialog.display()) {
            this.getModel().fireTableDataChanged();
        }
        this.getModel().fireTableDataChanged();
    }

    protected CorrelationItemsTableModel getModel() {
        return (CorrelationItemsTableModel)super.getModel();
    }

    private void init() {
        this.getTable().getColumn(0).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                CorrelationItem item = (CorrelationItem)CorrelationItemsTable.this.getModel().getRow(this.getRow());
                CorrelationKey key = item.getCorrelationKey();
                return !CorrelationItemsTable.this.getAvailableKeys().contains(key) ? Color.RED : null;
            }

            public Color getBackground(Object element) {
                return Color.WHITE;
            }
        });
        for (CorrelationItem item : this.correlationItemsContainer.getCorrelationItems()) {
            this.getModel().addRow(item);
        }
    }

    private Sequence<CorrelationKey> getAvailableKeys() {
        return this.correlationItemsContainer.getScopedCorrelationKeys();
    }
}

