/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.correlation.CorrelationItemsTableModel;
import oracle.bpm.designer.correlation.CorrelationKeyDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.AddCorrelationKeyCommand;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CorrelationItemDialog
extends ObjectEditorDialog<CorrelationItem> {
    private CorrelationItemsTableModel checkModel;
    private CorrelationItemsContainer container;
    private ReferenceComboBox<CorrelationKey> correlationKeyComboBox;
    private CheckBox initiatesCheckBox;

    public CorrelationItemDialog(@NotNull UiWindow parent, @Nullable CorrelationItem correlationItem, @NotNull CorrelationItemsContainer container, @NotNull CorrelationItemsTableModel checkModel) {
        super(parent, DesignerMsg.CORRELATION_KEY, (Object)correlationItem);
        this.container = container;
        this.checkModel = checkModel;
    }

    public boolean isCorrelationKeyInUse(@NotNull CorrelationKey key) {
        for (CorrelationItem correlationItem : this.checkModel.getData()) {
            if (!correlationItem.getCorrelationKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    protected void setObjectFromEditor(@NotNull CorrelationItem object) {
        CorrelationKey correlationKey = (CorrelationKey)this.correlationKeyComboBox.getValue();
        boolean initiates = this.initiatesCheckBox.isSelected();
        object.setCorrelationKey(correlationKey);
        object.setInitiates(initiates);
    }

    protected CorrelationItem createObjectFromEditor() {
        CorrelationKey correlationKey = (CorrelationKey)this.correlationKeyComboBox.getValue();
        boolean initiates = this.initiatesCheckBox.isSelected();
        return this.container.createCorrelationItem(correlationKey, initiates);
    }

    protected void setEditorFromObject(@NotNull CorrelationItem object) {
        this.correlationKeyComboBox.setValue((Object)object.getCorrelationKey());
        this.initiatesCheckBox.setSelected(object.initiates());
    }

    protected void setEditorDefaultValues() {
        this.correlationKeyComboBox.setValue((Object)this.getDefaultCorrelationKey());
        if (this.correlationKeyComboBox.getValue() == null && this.correlationKeyComboBox.getItemCount() > 0) {
            this.correlationKeyComboBox.setSelectedIndex(0);
        }
        this.initiatesCheckBox.setSelected(false);
    }

    protected Msg validateInput() {
        if (!this.correlationKeyComboBox.isValidSelection()) {
            return DesignerMsg.DYNAMIC_SELECTION_INVALID(DesignerMsg.CORRELATION_KEY);
        }
        CorrelationKey correlationKey = (CorrelationKey)this.correlationKeyComboBox.getValue();
        if (correlationKey == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.CORRELATION_KEY);
        }
        if ((this.isNew() || !correlationKey.equals(((CorrelationItem)this.getObject()).getCorrelationKey())) && this.isCorrelationKeyInUse(correlationKey)) {
            return DesignerMsg.DYNAMIC_ALREADY_DEFINED(DesignerMsg.CORRELATION_KEY);
        }
        return null;
    }

    protected void layoutControls(@NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.CORRELATION_KEY));
        this.correlationKeyComboBox = this.createCorrelationKeyComboBox(container);
        this.reloadCorrelationKeysComboBoxModel();
        container.add(this.correlationKeyComboBox, (Object)"growx");
        Button newPropertyButton = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.NEW_CORRELATION_KEY);
        newPropertyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CorrelationKeyContainer container = CorrelationItemDialog.this.getImmediateCorrelationKeyContainer();
                CorrelationKeyDialog dialog = new CorrelationKeyDialog(Ui.getRoot(), container, null);
                if (dialog.display()) {
                    CorrelationKey newCorrelationKey = (CorrelationKey)dialog.getObject();
                    ActionRunner.getInstance().run((Command)new AddCorrelationKeyCommand(container, newCorrelationKey));
                    CorrelationItemDialog.this.reloadCorrelationKeysComboBoxModel();
                    CorrelationItemDialog.this.correlationKeyComboBox.setValue((Object)newCorrelationKey);
                }
            }
        });
        container.add((UiComponent)newPropertyButton, (Object)"wrap");
        this.initiatesCheckBox = new CheckBox(container);
        this.initiatesCheckBox.setMsg(DesignerMsg.INITIATES);
        container.add((UiComponent)this.initiatesCheckBox, (Object)"skip 1");
        this.setSize(300, 120);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private CorrelationKeyContainer getImmediateCorrelationKeyContainer() {
        for (CorrelationItemsContainer parent = this.container; parent != null; parent = parent.getParentObject()) {
            if (!CorrelationKeyContainer.class.isAssignableFrom(parent.getRawClass())) continue;
            return (CorrelationKeyContainer)parent;
        }
        return null;
    }

    private ReferenceComboBox<CorrelationKey> createCorrelationKeyComboBox(@NotNull UiContainer container) {
        ReferenceComboBox result = new ReferenceComboBox(container);
        LabelProvider.Default<CorrelationKey> labelProvider = new LabelProvider.Default<CorrelationKey>(){

            public String getText(CorrelationKey element) {
                return element != null ? element.getName() : DesignerMsg.REQUIRED_COMBOBOX_NULL_LABEL.getString();
            }
        };
        result.setLabelProvider((LabelProvider)labelProvider);
        return result;
    }

    private void reloadCorrelationKeysComboBoxModel() {
        List<CorrelationKey> keyList = CollectionUtils.toList(this.getAvailableKeys());
        this.correlationKeyComboBox.setModelList(keyList);
    }

    private Sequence<CorrelationKey> getAvailableKeys() {
        CorrelationItemsContainer itemsContainer = this.container;
        return itemsContainer.getScopedCorrelationKeys();
    }

    @Nullable
    private CorrelationKey getDefaultCorrelationKey() {
        for (CorrelationKey key : this.getAvailableKeys()) {
            if (this.isCorrelationKeyInUse(key)) continue;
            return key;
        }
        return null;
    }
}

