/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import oracle.bpm.designer.correlation.CorrelationPropertyExpressionsCache;
import oracle.bpm.designer.correlation.CorrelationsContainerPanel;
import oracle.bpm.designer.correlation.CorrelationsPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.InputCorrelationsEnabled;
import oracle.bpm.project.model.processes.correlations.OutputCorrelationsEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CorrelationDialog
extends OkCancelDialog {
    private CorrelationsEnabled correlationsEnabled;
    private CorrelationsPanel inputPanel;
    private CorrelationsPanel outputPanel;

    public CorrelationDialog(@NotNull UiWindow parent, @NotNull CorrelationsEnabled correlationsEnabled) {
        super(parent, DesignerMsg.CORRELATION_DEFINITION);
        this.correlationsEnabled = correlationsEnabled;
        this.init();
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        if (this.inputPanel != null) {
            this.inputPanel.applyChanges();
        }
        if (this.outputPanel != null) {
            this.outputPanel.applyChanges();
        }
        this.close();
    }

    private void init() {
        CorrelationItemsContainer container;
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        UiContainer containerPanel = this.correlationsEnabled.isInputCorrelationsEnabled() && this.correlationsEnabled.isOutputCorrelationsEnabled() ? this.buildTabbedPane(panel) : this.buildPanel(panel);
        panel.add((UiComponent)containerPanel, (Object)"grow");
        CorrelationPropertyExpressionsCache inputPropertyExpressionsCache = null;
        if (this.correlationsEnabled.isInputCorrelationsEnabled()) {
            InputCorrelationsEnabled inputCorrelations = (InputCorrelationsEnabled)this.correlationsEnabled;
            container = inputCorrelations.getInputCorrelationsContainer();
            inputPropertyExpressionsCache = new CorrelationPropertyExpressionsCache();
            this.inputPanel = new CorrelationsContainerPanel(containerPanel, container, inputPropertyExpressionsCache);
            this.addContent(containerPanel, (UiComponent)this.inputPanel, DesignerMsg.INPUT);
        }
        if (this.correlationsEnabled.isOutputCorrelationsEnabled()) {
            OutputCorrelationsEnabled outputCorrelationsEnabled = (OutputCorrelationsEnabled)this.correlationsEnabled;
            container = outputCorrelationsEnabled.getOutputCorrelationsContainer();
            CorrelationPropertyExpressionsCache outputPropertyExpressionsCache = container.getParentObject().hasSameCorrelationMessage() && inputPropertyExpressionsCache != null ? inputPropertyExpressionsCache : new CorrelationPropertyExpressionsCache();
            this.outputPanel = new CorrelationsContainerPanel(containerPanel, container, outputPropertyExpressionsCache);
            this.addContent(containerPanel, (UiComponent)this.outputPanel, DesignerMsg.OUTPUT);
        }
        this.setSize(500, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void addContent(@NotNull UiContainer container, @NotNull UiComponent content, @NotNull Msg title) {
        if (container instanceof TabbedPane) {
            TabbedPane tabbedPane = (TabbedPane)container;
            tabbedPane.addTab(title, content);
        } else {
            container.add(content, (Object)"grow");
        }
    }

    private UiContainer buildTabbedPane(@NotNull UiContainer parent) {
        return new TabbedPane(parent);
    }

    private UiContainer buildPanel(@NotNull UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        return result;
    }

    private Msg validateInput() {
        Msg msg;
        if (this.inputPanel != null && (msg = this.inputPanel.validateInput()) != null) {
            return msg;
        }
        if (this.outputPanel != null && (msg = this.outputPanel.validateInput()) != null) {
            return msg;
        }
        return null;
    }
}

