/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.correlation;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.correlation.CorrelationItemsTable;
import oracle.bpm.designer.correlation.CorrelationPropertyExpressionsCache;
import oracle.bpm.designer.correlation.CorrelationPropertyRetrievalExpressionsPanel;
import oracle.bpm.designer.correlation.CorrelationsPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.process.CorrelationHelper;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.CorrelationPropertyAlias;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class AdvancedCorrelationsPanel
extends CorrelationsPanel {
    private CorrelationPropertyExpressionsCache cacheModel;
    private CorrelationItemsContainer container;
    private CorrelationPropertyRetrievalExpressionsPanel retrievalExpressionsPanel;
    private CorrelationItemsTable table;

    public AdvancedCorrelationsPanel(@NotNull UiContainer parent, @NotNull CorrelationItemsContainer container, @NotNull CorrelationPropertyExpressionsCache cacheModel) {
        super(parent);
        this.container = container;
        this.cacheModel = cacheModel;
        this.init();
    }

    @Override
    void applyChanges() {
        this.container.clearCorrelationItems();
        for (CorrelationItem item : this.table.getCorrelationItems()) {
            try {
                this.container.addCorrelationItem(item);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        Project project = this.container.getProject();
        Sequence<CorrelationPropertyAlias> propertyAliases = this.cacheModel.buildPropertyAliases(this.container, this.getSelectedCorrelationKeys());
        for (CorrelationPropertyAlias propertyAlias : propertyAliases) {
            try {
                project.setPropertyAlias(propertyAlias);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    @Override
    Msg validateInput() {
        Sequence<CorrelationItem> items = this.table.getCorrelationItems();
        for (CorrelationItem item : items) {
            if (this.container.getScopedCorrelationKeys().contains(item.getCorrelationKey())) continue;
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.CORRELATION_PROPERTY_ALIAS);
        }
        if (this.retrievalExpressionsPanel.hasUnknownProperties()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.CORRELATION_PROPERTY);
        }
        if (this.retrievalExpressionsPanel.hasEmptyExpressions()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_NULL(DesignerMsg.CORRELATION_PROPERTY_ALIAS);
        }
        if (this.retrievalExpressionsPanel.hasInvalidExpressions()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.CORRELATION_PROPERTY_ALIAS);
        }
        return null;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, fill"));
        this.table = new CorrelationItemsTable((UiContainer)this, this.container);
        this.add((UiComponent)this.table, "height 110!, growx, wrap");
        this.table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                AdvancedCorrelationsPanel.this.rebuildRetrievalExpressionsPanel();
            }
        });
        this.rebuildRetrievalExpressionsPanel();
    }

    private void rebuildRetrievalExpressionsPanel() {
        if (this.retrievalExpressionsPanel != null) {
            this.retrievalExpressionsPanel.dispose();
            this.retrievalExpressionsPanel.getParent().remove((UiComponent)this.retrievalExpressionsPanel);
        }
        Sequence properties = CorrelationHelper.getPropertiesUnion(this.getSelectedCorrelationKeys());
        this.retrievalExpressionsPanel = new CorrelationPropertyRetrievalExpressionsPanel((UiContainer)this, this.container, properties, this.cacheModel);
        this.add((UiComponent)this.retrievalExpressionsPanel, "grow");
        this.revalidate();
    }

    private Sequence<CorrelationKey> getSelectedCorrelationKeys() {
        ArrayList<CorrelationKey> result = new ArrayList<CorrelationKey>();
        for (CorrelationItem item : this.table.getCorrelationItems()) {
            result.add(item.getCorrelationKey());
        }
        return CollectionUtils.asSequence(result);
    }
}

