/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversational;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.ProjectObjectBrowser;
import oracle.bpm.designer.conversation.InterfaceBrowser;
import oracle.bpm.designer.conversational.ConversationalDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.command.design.AddConversationCommand;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.UseInterfaceConversationalDefinition;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class UseInterfaceConversationalDefinitionPanel
extends ConversationalDefinitionPanel {
    private boolean applyChanges = false;
    private ProjectObjectBrowser<ErrorObject> errorBrowser;
    private ReferenceComboBox<CatalogMember> operationComboBox;
    private InterfaceBrowser<ReferenceObject> referenceBrowser;

    public UseInterfaceConversationalDefinitionPanel(@NotNull UiContainer parent, @NotNull Conversational conversational, boolean advancedMode) {
        super(parent, conversational, ProjectModelMsg.USE_INTERFACE, advancedMode);
        this.init();
    }

    @Override
    protected Msg validateInput() {
        if (this.referenceBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.REFERENCE);
        }
        if (!this.referenceBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.REFERENCE);
        }
        if (this.operationComboBox.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.OPERATION);
        }
        if (!this.operationComboBox.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.OPERATION);
        }
        if (this.errorBrowser != null && !this.errorBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.ERROR);
        }
        return null;
    }

    private void init() {
        Conversation conversation;
        UseInterfaceConversationDefinition conversationDefinition;
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        Conversational conversational = this.getConversational();
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.REFERENCE));
        this.referenceBrowser = this.createReferenceBrowser((UiContainer)this);
        this.add((UiComponent)this.referenceBrowser, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OPERATION));
        this.operationComboBox = this.createOperationComboBox((UiContainer)this);
        this.add((UiComponent)this.operationComboBox, "growx, wrap");
        if (conversational.getConversationalType().isSender()) {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ERROR));
            this.errorBrowser = this.createErrorBrowser((UiContainer)this);
            this.add((UiComponent)this.errorBrowser, "growx, spanx");
            this.updateErrorBrowser();
        }
        UseInterfaceConversationDefinition useInterfaceConversationDefinition = conversationDefinition = (conversation = conversational.getConversation()) != null ? (UseInterfaceConversationDefinition)conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class) : null;
        if (conversationDefinition != null) {
            UseInterfaceConversationalDefinition conversationalDefinition = this.getConversationalDefinition();
            ReferenceObject reference = conversationalDefinition.getReference();
            this.referenceBrowser.setValue(reference);
            CatalogMember operation = conversationalDefinition.getOperation();
            this.operationComboBox.setSelectedItem((Object)operation);
            if (this.errorBrowser != null) {
                this.errorBrowser.setValue(conversationalDefinition.getError());
            }
        }
        this.applyChanges = true;
    }

    private InterfaceBrowser<ReferenceObject> createReferenceBrowser(@NotNull UiContainer container) {
        final InterfaceBrowser<ReferenceObject> result = InterfaceBrowser.createConverationalReferenceBrowser(container, this.getConversational());
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (result.isEnabled() && UseInterfaceConversationalDefinitionPanel.this.applyChanges) {
                    ReferenceObject selectedReference = (ReferenceObject)result.getValue();
                    Conversation conversation = null;
                    if (selectedReference != null) {
                        ConversationContainer conversationContainer;
                        if (selectedReference.isCallback()) {
                            selectedReference = (ReferenceObject)selectedReference.getParentObject();
                        }
                        if ((conversation = ConversationalHelper.findDefaultUseInterfaceConversation((ConversationContainer)(conversationContainer = UseInterfaceConversationalDefinitionPanel.this.getDefaultConversationContainer()), (ReferenceObject)selectedReference)) == null) {
                            conversation = conversationContainer.createDefaultConversation(ConversationType.USE_INTERFACE);
                            UseInterfaceConversationDefinition definition = (UseInterfaceConversationDefinition)conversation.getConversationDefinition().as(UseInterfaceConversationDefinition.class);
                            definition.setReference(selectedReference);
                            ActionRunner.getInstance().run((Command)new AddConversationCommand(conversationContainer, conversation));
                        }
                    }
                    UseInterfaceConversationalDefinitionPanel.this.getConversational().setConversation(conversation);
                }
                UseInterfaceConversationalDefinitionPanel.this.reloadOperationComboBox();
            }
        });
        result.setEnabled(!this.isAdvancedMode());
        return result;
    }

    private ProjectObjectBrowser<ErrorObject> createErrorBrowser(@NotNull UiContainer container) {
        OperationErrorsFilter filter = new OperationErrorsFilter(this.operationComboBox);
        ProjectObjectBrowser<ErrorObject> result = new ProjectObjectBrowser<ErrorObject>(container, filter, (ProjectObjectContainer)this.getConversational());
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent modificationEvent) {
                UseInterfaceConversationalDefinitionPanel.this.getConversationalDefinition().setError((ErrorObject)UseInterfaceConversationalDefinitionPanel.this.errorBrowser.getValue());
            }
        });
        return result;
    }

    private ReferenceComboBox<CatalogMember> createOperationComboBox(@NotNull UiContainer container) {
        ReferenceComboBox result = new ReferenceComboBox(container);
        result.setLabelProvider((LabelProvider)new LabelProvider.Default<CatalogMember>(){

            public String getText(CatalogMember element) {
                return element.getName();
            }
        });
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UseInterfaceConversationalDefinition conversationalDefinition;
                if (UseInterfaceConversationalDefinitionPanel.this.applyChanges && (conversationalDefinition = UseInterfaceConversationalDefinitionPanel.this.getConversationalDefinition()) != null) {
                    CatalogMember selectedOperation = (CatalogMember)UseInterfaceConversationalDefinitionPanel.this.operationComboBox.getValue();
                    conversationalDefinition.setOperation(selectedOperation);
                }
                UseInterfaceConversationalDefinitionPanel.this.updateErrorBrowser();
            }
        });
        return result;
    }

    private void reloadOperationComboBox() {
        this.operationComboBox.removeAllItems();
        ReferenceObject selectedReference = (ReferenceObject)this.referenceBrowser.getValue();
        if (selectedReference != null) {
            for (CatalogMember operation : selectedReference.getChildrenByType(CatalogMember.class)) {
                this.operationComboBox.addItem((Object)operation);
            }
        }
    }

    private void updateErrorBrowser() {
        if (this.errorBrowser != null) {
            CatalogMember operation = this.operationComboBox.isValidSelection() ? (CatalogMember)this.operationComboBox.getValue() : null;
            this.errorBrowser.setEnabled(operation != null && !operation.getExceptions().isEmpty());
        }
    }

    private UseInterfaceConversationalDefinition getConversationalDefinition() {
        UseInterfaceConversationalDefinition result = null;
        ConversationalDefinition conversationalDefinition = this.getConversational().getConversationalDefinition();
        if (conversationalDefinition != null) {
            result = (UseInterfaceConversationalDefinition)conversationalDefinition.as(UseInterfaceConversationalDefinition.class);
        }
        return result;
    }

    private static class OperationErrorsFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ReferenceComboBox<CatalogMember> operationComboBox;

        private OperationErrorsFilter(@NotNull ReferenceComboBox<CatalogMember> operationComboBox) {
            this.operationComboBox = operationComboBox;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            CatalogMember operation;
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Conversational && (operation = (CatalogMember)this.operationComboBox.getValue()) != null) {
                result = operation.getExceptions();
            }
            return result;
        }
    }
}

