/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversational;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.conversation.InterfaceBrowser;
import oracle.bpm.designer.conversational.ConversationalDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.command.design.AddConversationCommand;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class ServiceCallConversationalDefinitionPanel
extends ConversationalDefinitionPanel {
    private boolean applyChanges = false;
    private ReferenceComboBox<CatalogMember> operationComboBox;
    private InterfaceBrowser<ServiceObject> serviceBrowser;

    public ServiceCallConversationalDefinitionPanel(@NotNull UiContainer parent, @NotNull Conversational conversational, boolean advancedMode) {
        super(parent, conversational, ProjectModelMsg.SERVICE_CALL, advancedMode);
        this.init();
    }

    @Override
    protected Msg validateInput() {
        if (this.serviceBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.SERVICE);
        }
        if (!this.serviceBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.SERVICE);
        }
        if (this.operationComboBox.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.OPERATION);
        }
        if (!this.operationComboBox.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.OPERATION);
        }
        return null;
    }

    private void init() {
        ServiceCallConversationDefinition conversationDefinition;
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERVICE));
        this.serviceBrowser = this.createServiceBrowser((UiContainer)this);
        this.add((UiComponent)this.serviceBrowser, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OPERATION));
        this.operationComboBox = this.createOperationComboBox((UiContainer)this);
        this.add((UiComponent)this.operationComboBox, "growx, wrap");
        Conversation conversation = this.getConversational().getConversation();
        ServiceCallConversationDefinition serviceCallConversationDefinition = conversationDefinition = conversation != null ? (ServiceCallConversationDefinition)conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class) : null;
        if (conversationDefinition != null) {
            ServiceCallConversationalDefinition conversationalDefinition = this.getConversationalDefinition();
            ServiceObject service = conversationalDefinition.getService();
            this.serviceBrowser.setValue(service);
            CatalogMember operation = conversationalDefinition.getOperation();
            this.operationComboBox.setSelectedItem((Object)operation);
        }
        this.applyChanges = true;
    }

    private InterfaceBrowser<ServiceObject> createServiceBrowser(@NotNull UiContainer container) {
        final InterfaceBrowser<ServiceObject> result = InterfaceBrowser.createConversationalServiceBrowser(container, this.getConversational());
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (result.isEnabled() && ServiceCallConversationalDefinitionPanel.this.applyChanges) {
                    ServiceObject selectedService = (ServiceObject)result.getValue();
                    Conversation conversation = null;
                    if (selectedService != null) {
                        ConversationContainer conversationContainer;
                        if (selectedService.isCallback()) {
                            selectedService = (ServiceObject)selectedService.getParentObject();
                        }
                        if ((conversation = ConversationalHelper.findDefaultServiceCallConversation((ConversationContainer)(conversationContainer = ServiceCallConversationalDefinitionPanel.this.getDefaultConversationContainer()), (ServiceObject)selectedService)) == null) {
                            conversation = conversationContainer.createDefaultConversation(ConversationType.SERVICE_CALL);
                            ServiceCallConversationDefinition definition = (ServiceCallConversationDefinition)conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class);
                            definition.setService(selectedService);
                            ActionRunner.getInstance().run((Command)new AddConversationCommand(conversationContainer, conversation));
                        }
                    }
                    ServiceCallConversationalDefinitionPanel.this.getConversational().setConversation(conversation);
                }
                ServiceCallConversationalDefinitionPanel.this.reloadOperationComboBox();
            }
        });
        result.setEnabled(!this.isAdvancedMode());
        return result;
    }

    private ReferenceComboBox<CatalogMember> createOperationComboBox(@NotNull UiContainer container) {
        ReferenceComboBox result = new ReferenceComboBox(container);
        result.setLabelProvider((LabelProvider)new LabelProvider.Default<CatalogMember>(){

            public String getText(CatalogMember element) {
                return element.getName();
            }
        });
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ServiceCallConversationalDefinition conversationalDefinition;
                if (ServiceCallConversationalDefinitionPanel.this.applyChanges && (conversationalDefinition = ServiceCallConversationalDefinitionPanel.this.getConversationalDefinition()) != null) {
                    CatalogMember selectedOperation = (CatalogMember)ServiceCallConversationalDefinitionPanel.this.operationComboBox.getValue();
                    conversationalDefinition.setOperation(selectedOperation);
                }
            }
        });
        return result;
    }

    private void reloadOperationComboBox() {
        this.operationComboBox.removeAllItems();
        ServiceObject selectedService = (ServiceObject)this.serviceBrowser.getValue();
        if (selectedService != null) {
            for (CatalogMember operation : selectedService.getChildrenByType(CatalogMember.class)) {
                this.operationComboBox.addItem((Object)operation);
            }
        }
    }

    private ServiceCallConversationalDefinition getConversationalDefinition() {
        ServiceCallConversationalDefinition result = null;
        ConversationalDefinition conversationalDefinition = this.getConversational().getConversationalDefinition();
        if (conversationalDefinition != null) {
            result = (ServiceCallConversationalDefinition)conversationalDefinition.as(ServiceCallConversationalDefinition.class);
        }
        return result;
    }
}

