/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversational;

import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.conversation.ProcessBrowser;
import oracle.bpm.designer.conversational.ConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.ConversationalLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.command.design.AddConversationCommand;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ConversationalDefinition;
import oracle.bpm.project.model.processes.conversational.ConversationalType;
import oracle.bpm.project.model.processes.conversational.ProcessCallConversationalDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class ProcessCallConversationalDefinitionPanel
extends ConversationalDefinitionPanel {
    private boolean applyChanges = false;
    private ProcessBrowser processBrowser;
    private ReferenceComboBox<Conversational> targetConversationalComboBox;

    public ProcessCallConversationalDefinitionPanel(@NotNull UiContainer parent, @NotNull Conversational conversational, boolean advancedMode) {
        super(parent, conversational, ProjectModelMsg.PROCESS_CALL, advancedMode);
        this.init();
    }

    @Override
    protected Msg validateInput() {
        if (this.processBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.PROCESS);
        }
        if (!this.processBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.PROCESS);
        }
        if (this.targetConversationalComboBox.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.TARGET_NODE);
        }
        if (!this.targetConversationalComboBox.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.TARGET_NODE);
        }
        return null;
    }

    private void init() {
        ProcessCallConversationDefinition conversationDefinition;
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROCESS));
        this.processBrowser = this.createProcessBrowser((UiContainer)this);
        this.add((UiComponent)this.processBrowser, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TARGET_NODE));
        this.targetConversationalComboBox = this.createTargetConversationalComboBox((UiContainer)this);
        this.add((UiComponent)this.targetConversationalComboBox, "growx, wrap");
        Conversation conversation = this.getConversational().getConversation();
        ProcessCallConversationDefinition processCallConversationDefinition = conversationDefinition = conversation != null ? (ProcessCallConversationDefinition)conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class) : null;
        if (conversationDefinition != null) {
            Process process = conversationDefinition.getProcess();
            this.processBrowser.setValue(process);
            ProcessCallConversationalDefinition conversationalDefinition = this.getConversationalDefinition();
            Conversational targetConversational = conversationalDefinition.getTargetConversational();
            this.targetConversationalComboBox.setSelectedItem((Object)targetConversational);
        }
        this.applyChanges = true;
    }

    private ProcessBrowser createProcessBrowser(@NotNull UiContainer container) {
        Project project = this.getConversational().getProject();
        final ProcessBrowser result = ProcessBrowser.create(container, project);
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (result.isEnabled() && ProcessCallConversationalDefinitionPanel.this.applyChanges) {
                    ConversationContainer conversationContainer;
                    Process selectedProcess = (Process)result.getValue();
                    Conversation conversation = null;
                    if (selectedProcess != null && (conversation = ConversationalHelper.findDefaultProcessCallConversation((ConversationContainer)(conversationContainer = ProcessCallConversationalDefinitionPanel.this.getDefaultConversationContainer()), (Process)selectedProcess)) == null) {
                        conversation = conversationContainer.createDefaultConversation(ConversationType.PROCESS_CALL);
                        ProcessCallConversationDefinition definition = (ProcessCallConversationDefinition)conversation.getConversationDefinition().as(ProcessCallConversationDefinition.class);
                        definition.setProcess(selectedProcess);
                        ActionRunner.getInstance().run((Command)new AddConversationCommand(conversationContainer, conversation));
                    }
                    ProcessCallConversationalDefinitionPanel.this.getConversational().setConversation(conversation);
                }
                ProcessCallConversationalDefinitionPanel.this.reloadTargetConversationalComboBox();
            }
        });
        result.setEnabled(!this.isAdvancedMode());
        return result;
    }

    private ReferenceComboBox<Conversational> createTargetConversationalComboBox(@NotNull UiContainer container) {
        ReferenceComboBox result = new ReferenceComboBox(container);
        result.setLabelProvider((LabelProvider)new ConversationalLabelProvider());
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ProcessCallConversationalDefinition conversationalDefinition;
                if (ProcessCallConversationalDefinitionPanel.this.applyChanges && (conversationalDefinition = ProcessCallConversationalDefinitionPanel.this.getConversationalDefinition()) != null) {
                    Conversational selectedConversational = (Conversational)ProcessCallConversationalDefinitionPanel.this.targetConversationalComboBox.getValue();
                    conversationalDefinition.setTargetConversational(selectedConversational);
                }
            }
        });
        return result;
    }

    private void reloadTargetConversationalComboBox() {
        this.targetConversationalComboBox.removeAllItems();
        Process selectedProcess = (Process)this.processBrowser.getValue();
        if (selectedProcess != null) {
            ConversationalType conversationalType = this.getConversational().getConversationalType();
            Sequence processConversationalNodes = ConversationalHelper.getProcessCallConversationals((ConversationalType)conversationalType, (Process)selectedProcess);
            for (Conversational processConversationalNode : processConversationalNodes) {
                this.targetConversationalComboBox.addItem((Object)processConversationalNode);
            }
        }
    }

    private ProcessCallConversationalDefinition getConversationalDefinition() {
        ProcessCallConversationalDefinition result = null;
        ConversationalDefinition conversationalDefinition = this.getConversational().getConversationalDefinition();
        if (conversationalDefinition != null) {
            result = (ProcessCallConversationalDefinition)conversationalDefinition.as(ProcessCallConversationalDefinition.class);
        }
        return result;
    }
}

