/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversational;

import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.ProjectObjectBrowser;
import oracle.bpm.designer.argumentsdefinition.ArgumentsDefinitionPanel;
import oracle.bpm.designer.conversational.ConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.ConversationalLabelProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.RadioButtonSelectorPanel;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Str;
import oracle.bpm.project.command.design.AddConversationCommand;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

class DefineInterfaceConversationalDefinitionPanel
extends ConversationalDefinitionPanel {
    private DefinitionSelectorPanel definitionSelectorPanel;

    public DefineInterfaceConversationalDefinitionPanel(@NotNull UiContainer parent, @NotNull Conversational conversational, boolean advancedMode) {
        super(parent, conversational, ProjectModelMsg.DEFINE_INTERFACE, advancedMode);
        this.init();
    }

    @Override
    protected Msg validateInput() {
        return this.definitionSelectorPanel.validateInput();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        if (this.getConversational().getConversation() == null) {
            Conversation conversation = this.getOrCreateDefaultConversation();
            this.getConversational().setConversation(conversation);
        }
        Conversational conversational = this.getConversational();
        DefineInterfaceConversationalDefinition conversationalDefinition = (DefineInterfaceConversationalDefinition)conversational.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
        DataDeclarationContainer argumentsContainer = conversationalDefinition.getArgumentsContainer();
        DataDeclarationContainer inputsContainer = conversational.getConversationalType().isReceiver() ? argumentsContainer : null;
        DataDeclarationContainer outputsContainer = conversational.getConversationalType().isSender() ? argumentsContainer : null;
        ArgumentsDefinitionPanel argumentsDefinitionPanel = new ArgumentsDefinitionPanel((UiContainer)this, inputsContainer, outputsContainer, false);
        this.add((UiComponent)argumentsDefinitionPanel, "growx, height 100!, spanx, wrap");
        this.definitionSelectorPanel = new DefinitionSelectorPanel((UiContainer)this, conversationalDefinition);
        this.add((UiComponent)this.definitionSelectorPanel, "growx, spanx");
    }

    private Conversation getOrCreateDefaultConversation() {
        ConversationContainer conversationContainer = this.getDefaultConversationContainer();
        Conversation result = ConversationalHelper.findDefaultDefineInterfaceConversation((ConversationContainer)conversationContainer);
        if (result == null) {
            result = conversationContainer.createDefaultConversation(ConversationType.DEFINE_INTERFACE);
            ActionRunner.getInstance().run((Command)new AddConversationCommand(conversationContainer, result));
        }
        return result;
    }

    private static class SyncPanel
    extends DefinitionPanel {
        private ProjectObjectBrowser<ErrorObject> errorBrowser;
        private ReferenceComboBox<Conversational> replyToComboBox;
        private CheckBox throwErrorCheckBox;

        public SyncPanel(@NotNull UiContainer parent, @NotNull DefineInterfaceConversationalDefinition definition) {
            super(parent, definition);
            this.init();
        }

        @Override
        public Msg validateInput() {
            if (this.replyToComboBox.getValue() == null) {
                return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.REPLY_TO);
            }
            if (!this.replyToComboBox.isValidSelection()) {
                return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.REPLY_TO);
            }
            if (this.throwErrorCheckBox.isSelected()) {
                if (this.errorBrowser.getValue() == null) {
                    return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.ERROR);
                }
                if (!this.errorBrowser.isValidSelection()) {
                    return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.ERROR);
                }
            }
            return null;
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.REPLY_TO));
            this.replyToComboBox = new ReferenceComboBox((UiContainer)this);
            Conversational conversational = this.getDefinition().getParentObject();
            Sequence replyToConversationals = ConversationalHelper.getPossibleReplyTos((Conversational)conversational);
            for (Conversational replyTo : replyToConversationals) {
                this.replyToComboBox.addItem((Object)replyTo);
            }
            this.replyToComboBox.setLabelProvider((LabelProvider)new ConversationalLabelProvider());
            this.replyToComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SyncPanel.this.getDefinition().setReplyTo((Conversational)SyncPanel.this.replyToComboBox.getValue());
                    SyncPanel.this.errorBrowser.setValue(null);
                }
            });
            this.add((UiComponent)this.replyToComboBox, "growx");
            Button clearReplyToButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
            clearReplyToButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SyncPanel.this.replyToComboBox.setValue(null);
                }
            });
            this.add((UiComponent)clearReplyToButton, "wrap");
            this.throwErrorCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.THROW_ERROR);
            this.throwErrorCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean selected = SyncPanel.this.throwErrorCheckBox.isSelected();
                    SyncPanel.this.errorBrowser.setEnabled(selected);
                    SyncPanel.this.errorBrowser.setValue(null);
                }
            });
            this.add((UiComponent)this.throwErrorCheckBox);
            ReplyToErrorsFilter filter = new ReplyToErrorsFilter(this.replyToComboBox);
            this.errorBrowser = new ProjectObjectBrowser((UiContainer)this, filter, (ProjectObjectContainer)conversational);
            this.errorBrowser.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent modificationEvent) {
                    SyncPanel.this.getDefinition().setError((ErrorObject)SyncPanel.this.errorBrowser.getValue());
                }
            });
            this.add((UiComponent)this.errorBrowser, "growx, spanx");
            this.replyToComboBox.setValue((Object)this.getDefinition().getReplyTo());
            ErrorObject error = this.getDefinition().getError();
            this.throwErrorCheckBox.setSelected(error != null);
            this.errorBrowser.setValue(error);
        }

        private static class ReplyToErrorsFilter
        extends DefaultProjectFilter
        implements ProjectFilter {
            private ReferenceComboBox<Conversational> replyToComboBox;

            private ReplyToErrorsFilter(@NotNull ReferenceComboBox<Conversational> replyToComboBox) {
                this.replyToComboBox = replyToComboBox;
            }

            @NotNull
            public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
                Sequence result = CollectionUtils.emptySequence();
                if (object instanceof Conversational) {
                    Conversational replyTo = (Conversational)this.replyToComboBox.getValue();
                    if (this.replyToComboBox.isValidSelection() && replyTo != null) {
                        result = ConversationalHelper.getReplyToErrors((Conversational)replyTo);
                    }
                }
                return result;
            }
        }
    }

    private static class DefinitionSelectorPanel
    extends RadioButtonSelectorPanel<SyncronicityOptions> {
        private DefineInterfaceConversationalDefinition definition;

        public DefinitionSelectorPanel(@NotNull UiContainer parent, @NotNull DefineInterfaceConversationalDefinition definition) {
            super(parent, null);
            this.definition = definition;
            this.init();
        }

        public Msg validateInput() {
            return this.getInnerPanel().validateInput();
        }

        @Override
        public DefinitionPanel getInnerPanel() {
            return (DefinitionPanel)super.getInnerPanel();
        }

        @Override
        protected Panel createInnerPanel(@NotNull UiContainer container, @NotNull SyncronicityOptions selectedOption) {
            DefinitionPanel result = null;
            if (selectedOption == SyncronicityOptions.ASYNCHRONOUS) {
                Conversational conversational = this.definition.getParentObject();
                Msg definedOperationNameLabel = conversational.getConversationalType().isReceiver() ? DesignerMsg.OPERATION_NAME : DesignerMsg.CALLBACK_OPERATION_NAME;
                result = new DefinedOperationNamePanel(container, definedOperationNameLabel, this.definition);
            } else if (selectedOption == SyncronicityOptions.SYNCHRONOUS) {
                result = new SyncPanel(container, this.definition);
            }
            return result;
        }

        private void init() {
            this.addOption(SyncronicityOptions.ASYNCHRONOUS);
            this.addOption(SyncronicityOptions.SYNCHRONOUS);
            SyncronicityOptions selectedOption = this.definition.getReplyTo() != null ? SyncronicityOptions.SYNCHRONOUS : SyncronicityOptions.ASYNCHRONOUS;
            this.setSelectedOption(selectedOption);
            Conversational conversational = this.definition.getParentObject();
            if (conversational.getConversationalType().isReceiver()) {
                this.setSelectorVisible(false);
            }
        }
    }

    private static class DefinedOperationNamePanel
    extends DefinitionPanel {
        private Msg label;
        private TextField operationNameTextField;

        public DefinedOperationNamePanel(@NotNull UiContainer parent, @NotNull Msg label, @NotNull DefineInterfaceConversationalDefinition definition) {
            super(parent, definition);
            this.label = label;
            this.init();
        }

        @Override
        public Msg validateInput() {
            String operationName = this.operationNameTextField.getText();
            if (Str.isEmpty(operationName)) {
                return DesignerMsg.DYNAMIC_NOT_NULL(this.label);
            }
            if (!ConversationalHelper.isOperationNameValid((String)operationName)) {
                return DesignerMsg.DYNAMIC_INVALID(this.label);
            }
            if (ConversationalHelper.definedOperationNameExists((String)operationName, (DefineInterfaceConversationalDefinition)this.getDefinition())) {
                return DesignerMsg.DYNAMIC_ALREADY_DEFINED(this.label);
            }
            return null;
        }

        private void init() {
            this.setLayout((Layout)new BorderLayout(5, 0));
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)this.label), "West");
            this.operationNameTextField = new TextField((UiContainer)this);
            this.operationNameTextField.addDocumentListener((DocumentListener)new DocumentListener.Default(){

                public void anyUpdate(DocumentEvent e) {
                    DefinedOperationNamePanel.this.getDefinition().setDefinedOperationName(DefinedOperationNamePanel.this.operationNameTextField.getText());
                }
            });
            String definedOperationName = this.getDefinition().getDefinedOperationName();
            if (Str.isEmpty(definedOperationName)) {
                definedOperationName = ConversationalHelper.getDefaultDefinedOperationName((DefineInterfaceConversationalDefinition)this.getDefinition());
            }
            this.operationNameTextField.setText(definedOperationName);
            this.add((UiComponent)this.operationNameTextField, "Center");
        }
    }

    private static abstract class DefinitionPanel
    extends Panel {
        private DefineInterfaceConversationalDefinition definition;

        public DefinitionPanel(@NotNull UiContainer parent, @NotNull DefineInterfaceConversationalDefinition definition) {
            super(parent);
            this.definition = definition;
        }

        public abstract Msg validateInput();

        public DefineInterfaceConversationalDefinition getDefinition() {
            return this.definition;
        }
    }

    public static enum SyncronicityOptions implements I18nProvider
    {
        SYNCHRONOUS(DesignerMsg.SYNCHRONOUS),
        ASYNCHRONOUS(DesignerMsg.ASYNCHRONOUS);

        private Msg msg;

        private SyncronicityOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }
    }
}

