/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversational;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectBrowser;
import oracle.bpm.designer.conversation.ConversationLabelProvider;
import oracle.bpm.designer.conversational.ConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.ConversationsFilter;
import oracle.bpm.designer.conversational.DefineInterfaceConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.ProcessCallConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.ServiceCallConversationalDefinitionPanel;
import oracle.bpm.designer.conversational.UseInterfaceConversationalDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PlaceHolderPanel;
import oracle.bpm.ui.RadioButtonsPanel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationalPanel
extends Panel {
    private boolean applyChanges = false;
    private Conversational conversational;
    private PlaceHolderPanel conversationalDefinitionContainer;
    private ConversationalDefinitionPanel conversationalDefinitionPanel;
    private ProjectObjectBrowser<Conversation> conversationBrowser;
    private PlaceHolderPanel conversationBrowserContainer;
    private Label modeLabel;
    private RadioButtonsPanel<ConversationMode> modeRadioButtonsPanel;
    private Label nameLabel;
    private ReferenceComboBox<ConversationType> typeComboBox;

    public ConversationalPanel(@NotNull UiContainer parent, @NotNull Conversational conversational) {
        super(parent, DesignerMsg.MESSAGE_EXCHANGE);
        this.conversational = conversational;
        this.init();
    }

    public void validateInput() throws ProjectException {
        Msg error = null;
        if (!this.typeComboBox.isValidSelection()) {
            error = DesignerMsg.DYNAMIC_INVALID(DesignerMsg.TYPE);
        }
        if (error == null && this.modeRadioButtonsPanel.getSelectedValue() == ConversationMode.ADVANCED) {
            if (this.conversationBrowser.getValue() == null) {
                error = DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.CONVERSATION);
            } else if (!this.conversationBrowser.isValidSelection()) {
                error = DesignerMsg.DYNAMIC_INVALID(DesignerMsg.CONVERSATION);
            }
        }
        if (error == null && this.conversationalDefinitionPanel != null) {
            error = this.conversationalDefinitionPanel.validateInput();
        }
        if (error != null) {
            throw new ProjectException((ProjectObject)this.conversational, error);
        }
    }

    private void init() {
        this.layout();
        this.resetMode();
        this.load();
        this.applyChanges = true;
    }

    private void layout() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, hidemode 3, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.TYPE));
        this.typeComboBox = this.createTypeComboBox((UiContainer)this);
        this.add((UiComponent)this.typeComboBox, "growx, pushx, wrap");
        this.modeLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.CONVERSATION);
        this.modeLabel.makeRecyclable();
        this.add((UiComponent)this.modeLabel);
        this.modeRadioButtonsPanel = this.createModeRadioButtonsPanel((UiContainer)this);
        this.add((UiComponent)this.modeRadioButtonsPanel, "growx, pushx, wrap");
        this.nameLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.NAME);
        this.nameLabel.makeRecyclable();
        this.add((UiComponent)this.nameLabel);
        this.conversationBrowserContainer = this.createPlaceHolderContainer((UiContainer)this);
        this.add((UiComponent)this.conversationBrowserContainer, "growx, pushx, wrap");
        this.conversationalDefinitionContainer = this.createPlaceHolderContainer((UiContainer)this);
        this.add((UiComponent)this.conversationalDefinitionContainer, "growx, spanx, wrap");
    }

    private void load() {
        boolean isDefault;
        Conversation conversation = this.conversational.getConversation();
        ConversationType conversationType = conversation != null ? conversation.getConversationType() : null;
        this.typeComboBox.setSelectedItem((Object)conversationType);
        if (this.typeComboBox.isValidSelection() && conversation != null && !(isDefault = conversation.isDefaultConversation())) {
            this.modeRadioButtonsPanel.setSelectedValue((Object)ConversationMode.ADVANCED);
            this.conversationBrowser.setValue(conversation);
        }
    }

    private PlaceHolderPanel createPlaceHolderContainer(@NotNull UiContainer container) {
        PlaceHolderPanel result = new PlaceHolderPanel(container);
        result.makeRecyclable();
        return result;
    }

    private ReferenceComboBox<ConversationType> createTypeComboBox(@NotNull UiContainer container) {
        ReferenceComboBox result = new ReferenceComboBox(container);
        result.addItem(null);
        Sequence availableConversationTypes = ConversationalHelper.getAvailableConversationTypes((Conversational)this.conversational);
        for (ConversationType conversationType : availableConversationTypes) {
            result.addItem((Object)conversationType);
        }
        result.setLabelProvider((LabelProvider)new LabelProvider<ConversationType>(){

            public Image getIcon(ConversationType type) {
                Msg msg = type != null ? type.getMsg() : DesignerMsg.NOT_IMPLEMENTED;
                return Image.create((Msg)msg);
            }

            public String getText(ConversationType type) {
                Msg msg = type != null ? type.getMsg() : DesignerMsg.NOT_IMPLEMENTED;
                return msg.getString();
            }
        });
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ConversationalPanel.this.applyChanges) {
                    ConversationalPanel.this.conversational.setConversation(null);
                }
                ConversationalPanel.this.resetMode();
            }
        });
        return result;
    }

    private RadioButtonsPanel<ConversationMode> createModeRadioButtonsPanel(@NotNull UiContainer container) {
        List<ConversationMode> conversationModes = Arrays.asList(ConversationMode.values());
        RadioButtonsPanel result = new RadioButtonsPanel(container, conversationModes, true);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    if (ConversationalPanel.this.applyChanges) {
                        ConversationalPanel.this.conversational.setConversation(null);
                    }
                    ConversationalPanel.this.resetConversationBrowser();
                }
            }
        });
        result.makeRecyclable();
        return result;
    }

    private void resetMode() {
        boolean visible = this.typeComboBox.isValidSelection() && this.typeComboBox.getSelectedItem() != null;
        this.modeRadioButtonsPanel.setVisible(visible);
        this.modeLabel.setVisible(visible);
        this.modeRadioButtonsPanel.setSelectedValue((Object)ConversationMode.DEFAULT);
        this.resetConversationBrowser();
    }

    private void resetConversationBrowser() {
        boolean isAdvanced = this.modeRadioButtonsPanel.getSelectedValue() == ConversationMode.ADVANCED;
        this.conversationBrowser = null;
        if (isAdvanced) {
            ConversationType conversationType = (ConversationType)this.typeComboBox.getSelectedItem();
            if (this.typeComboBox.isValidSelection() && conversationType != null) {
                this.conversationBrowser = this.createConversationBrowser((UiContainer)this.conversationBrowserContainer, this.conversational, conversationType);
            }
        }
        this.conversationBrowserContainer.setContent(this.conversationBrowser);
        boolean visible = this.conversationBrowser != null;
        this.conversationBrowserContainer.setVisible(visible);
        this.nameLabel.setVisible(visible);
        this.revalidate();
        this.resetDefinition();
    }

    private void resetDefinition() {
        ConversationMode mode;
        ConversationType selectedItem;
        this.conversationalDefinitionPanel = null;
        if (this.typeComboBox.isValidSelection() && (selectedItem = (ConversationType)this.typeComboBox.getSelectedItem()) != null && ((mode = (ConversationMode)this.modeRadioButtonsPanel.getSelectedValue()) == ConversationMode.DEFAULT || this.conversationBrowser.getValue() != null)) {
            boolean advancedMode;
            boolean bl = advancedMode = mode == ConversationMode.ADVANCED;
            if (selectedItem == ConversationType.DEFINE_INTERFACE) {
                this.conversationalDefinitionPanel = new DefineInterfaceConversationalDefinitionPanel((UiContainer)this.conversationalDefinitionContainer, this.conversational, advancedMode);
            } else if (selectedItem == ConversationType.USE_INTERFACE) {
                this.conversationalDefinitionPanel = new UseInterfaceConversationalDefinitionPanel((UiContainer)this.conversationalDefinitionContainer, this.conversational, advancedMode);
            } else if (selectedItem == ConversationType.SERVICE_CALL) {
                this.conversationalDefinitionPanel = new ServiceCallConversationalDefinitionPanel((UiContainer)this.conversationalDefinitionContainer, this.conversational, advancedMode);
            } else if (selectedItem == ConversationType.PROCESS_CALL) {
                this.conversationalDefinitionPanel = new ProcessCallConversationalDefinitionPanel((UiContainer)this.conversationalDefinitionContainer, this.conversational, advancedMode);
            }
        }
        this.conversationalDefinitionContainer.setContent((UiComponent)this.conversationalDefinitionPanel);
        this.conversationalDefinitionContainer.setVisible(this.conversationalDefinitionPanel != null);
        this.revalidate();
    }

    private ProjectObjectBrowser<Conversation> createConversationBrowser(@NotNull UiContainer container, final @NotNull Conversational conversational, @NotNull ConversationType conversationType) {
        ConversationsFilter filter = new ConversationsFilter(conversationType);
        ProjectObjectBrowser<Conversation> result = new ProjectObjectBrowser<Conversation>(container, filter, (ProjectObjectContainer)conversational);
        result.setLabelProvider(new ConversationLabelProvider());
        result.setBrowserTitle(DesignerMsg.CONVERSATION);
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (ConversationalPanel.this.applyChanges) {
                    Conversation conversation = (Conversation)ConversationalPanel.this.conversationBrowser.getValue();
                    conversational.setConversation(conversation);
                }
                ConversationalPanel.this.resetDefinition();
            }
        });
        result.makeRecyclable();
        result.setNavigatorStatusLabelProvider((LabelProvider<ProjectObject>)new ConversationNavigatorStatusLabelProvider());
        return result;
    }

    private static class ConversationNavigatorStatusLabelProvider
    extends LabelProvider.Default<ProjectObject> {
        private ConversationNavigatorStatusLabelProvider() {
        }

        public String getText(ProjectObject element) {
            String result = "";
            if (element instanceof Conversation) {
                Conversation conversation = (Conversation)element;
                ConversationContainer conversationContainer = conversation.getParentObject();
                Path containerPath = this.getConversationContainerPath(conversationContainer);
                String conversationLabel = ProjectObjectRenderer.Default.getLabel((ProjectObject)conversation);
                Path conversationPath = Path.create((Path)containerPath, (String)conversationLabel);
                result = conversationPath.toString();
            }
            return result;
        }

        private Path getConversationContainerPath(@Nullable ConversationContainer container) {
            if (container != null) {
                ConversationContainer parentScope = container.getParentConversationsScope();
                Path parentPath = this.getConversationContainerPath(parentScope);
                String label = ProjectObjectRenderer.Default.getLabel((ProjectObject)container);
                return Path.create((Path)parentPath, (String)label);
            }
            return Path.create(null, (String)"/");
        }
    }

    private static enum ConversationMode implements I18nProvider
    {
        DEFAULT(DesignerMsg.DEFAULT_MSG),
        ADVANCED(DesignerMsg.ADVANCED);

        private Msg msg;

        private ConversationMode(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }
    }
}

