/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ConversationDefinitionPanel;
import oracle.bpm.designer.conversation.InterfaceBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UseInterfaceConversationDefinitionPanel
extends ConversationDefinitionPanel {
    private InterfaceBrowser<ReferenceObject> referenceBrowser;

    public UseInterfaceConversationDefinitionPanel(@NotNull UiContainer parent, @NotNull ConversationContainer container) {
        super(parent, container, DesignerMsg.DEFINITION);
        this.init();
    }

    @Override
    public void applyDefinition(@NotNull ConversationDefinition conversationDefinition) {
        UseInterfaceConversationDefinition useInterfaceConversationDefinition = (UseInterfaceConversationDefinition)conversationDefinition;
        useInterfaceConversationDefinition.setReference((ReferenceObject)this.referenceBrowser.getValue());
    }

    @Override
    public void loadDefinition(@NotNull ConversationDefinition conversationDefinition) {
        UseInterfaceConversationDefinition useInterfaceConversationDefinition = (UseInterfaceConversationDefinition)conversationDefinition;
        this.referenceBrowser.setValue(useInterfaceConversationDefinition.getReference());
    }

    @Override
    protected Msg validateInput(@Nullable Conversation conversation) {
        if (this.referenceBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.REFERENCE);
        }
        if (!this.referenceBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.REFERENCE);
        }
        return null;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.REFERENCE));
        this.referenceBrowser = this.createReferenceBrowser((UiContainer)this);
        this.referenceBrowser.setBrowserTitle(DesignerMsg.REFERENCE);
        this.add((UiComponent)this.referenceBrowser, "growx");
    }

    private InterfaceBrowser<ReferenceObject> createReferenceBrowser(@NotNull UiContainer container) {
        Project project = this.getConversationContainer().getProject();
        return InterfaceBrowser.createConverationReferenceBrowser(container, project);
    }
}

