/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ConversationDefinitionPanel;
import oracle.bpm.designer.conversation.InterfaceBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceCallConversationDefinitionPanel
extends ConversationDefinitionPanel {
    private InterfaceBrowser<ServiceObject> serviceBrowser;

    public ServiceCallConversationDefinitionPanel(@NotNull UiContainer parent, @NotNull ConversationContainer container) {
        super(parent, container, DesignerMsg.DEFINITION);
        this.init();
    }

    @Override
    public void applyDefinition(@NotNull ConversationDefinition conversationDefinition) {
        ServiceCallConversationDefinition serviceCallConversationDefinition = (ServiceCallConversationDefinition)conversationDefinition;
        serviceCallConversationDefinition.setService((ServiceObject)this.serviceBrowser.getValue());
    }

    @Override
    public void loadDefinition(@NotNull ConversationDefinition conversationDefinition) {
        ServiceCallConversationDefinition serviceCallConversationDefinition = (ServiceCallConversationDefinition)conversationDefinition;
        this.serviceBrowser.setValue(serviceCallConversationDefinition.getService());
    }

    @Override
    protected Msg validateInput(@Nullable Conversation conversation) {
        if (this.serviceBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.SERVICE);
        }
        if (!this.serviceBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.SERVICE);
        }
        return null;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERVICE));
        this.serviceBrowser = this.createServiceBrowser((UiContainer)this);
        this.serviceBrowser.setBrowserTitle(DesignerMsg.SERVICE);
        this.add((UiComponent)this.serviceBrowser, "growx");
    }

    private InterfaceBrowser<ServiceObject> createServiceBrowser(@NotNull UiContainer container) {
        Project project = this.getConversationContainer().getProject();
        return InterfaceBrowser.createConversationServiceBrowser(container, project);
    }
}

