/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ConversationDefinitionPanel;
import oracle.bpm.designer.conversation.ProcessBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ProcessCallConversationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProcessCallConversationDefinitionPanel
extends ConversationDefinitionPanel {
    private ProcessBrowser processBrowser;

    public ProcessCallConversationDefinitionPanel(@NotNull UiContainer parent, @NotNull ConversationContainer container) {
        super(parent, container, DesignerMsg.DEFINITION);
        this.init();
    }

    @Override
    public void applyDefinition(@NotNull ConversationDefinition conversationDefinition) {
        ProcessCallConversationDefinition processCallConversationDefinition = (ProcessCallConversationDefinition)conversationDefinition;
        processCallConversationDefinition.setProcess((Process)this.processBrowser.getValue());
    }

    @Override
    public void loadDefinition(@NotNull ConversationDefinition conversationDefinition) {
        ProcessCallConversationDefinition processCallConversationDefinition = (ProcessCallConversationDefinition)conversationDefinition;
        this.processBrowser.setValue(processCallConversationDefinition.getProcess());
    }

    @Override
    protected Msg validateInput(@Nullable Conversation conversation) {
        if (this.processBrowser.getValue() == null) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.PROCESS);
        }
        if (!this.processBrowser.isValidSelection()) {
            return DesignerMsg.DYNAMIC_INVALID(DesignerMsg.PROCESS);
        }
        return null;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROCESS));
        this.processBrowser = this.createProcessBrowser((UiContainer)this);
        this.add((UiComponent)this.processBrowser, "growx, spanx, wrap");
    }

    private ProcessBrowser createProcessBrowser(@NotNull UiContainer container) {
        Project project = this.getConversationContainer().getProject();
        return ProcessBrowser.create(container, project);
    }
}

