/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ProcessBrowser
extends ProjectObjectBrowser<Process> {
    private ProcessBrowser(@NotNull UiContainer parent, @NotNull ProjectFilter filter, @NotNull Project project) {
        super(parent, filter, (ProjectObjectContainer)project);
        this.init();
    }

    public static ProcessBrowser create(@NotNull UiContainer parent, @NotNull Project project) {
        ProcessCallConversationDefinitionFilter filter = new ProcessCallConversationDefinitionFilter();
        return new ProcessBrowser(parent, (ProjectFilter)filter, project);
    }

    private void init() {
        LabelProvider.Default<Process> labelProvider = new LabelProvider.Default<Process>(){

            public String getText(Process element) {
                return element.getName();
            }
        };
        this.setLabelProvider(labelProvider);
        this.setNavigatorStatusLabelProvider((LabelProvider<ProjectObject>)new LabelProvider.Default<ProjectObject>(){

            public String getText(ProjectObject element) {
                return element != null ? DesignerMsg.LABEL_ID(element.getName(), element.getId()).getString() : "";
            }
        });
        this.setBrowserTitle(DesignerMsg.PROCESS);
    }

    private static class ProcessCallConversationDefinitionFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ProcessCallConversationDefinitionFilter() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                Project project = (Project)object;
                result = ConversationalHelper.getProjectProcesses((Project)project);
            }
            return result;
        }
    }
}

