/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class InterfaceBrowser<T extends InterfaceObject>
extends ProjectObjectBrowser<T> {
    private InterfaceBrowser(@NotNull UiContainer parent, @NotNull ProjectFilter filter, @NotNull Project root) {
        super(parent, filter, (ProjectObjectContainer)root);
        this.init();
    }

    public static InterfaceBrowser<ServiceObject> createConversationServiceBrowser(@NotNull UiContainer parent, @NotNull Project project) {
        ServiceCallConversationDefinitionFilter filter = new ServiceCallConversationDefinitionFilter();
        return new InterfaceBrowser<ServiceObject>(parent, (ProjectFilter)filter, project);
    }

    public static InterfaceBrowser<ServiceObject> createConversationalServiceBrowser(@NotNull UiContainer parent, @NotNull Conversational conversational) {
        ServiceCallConversationalDefinitionFilter filter = new ServiceCallConversationalDefinitionFilter(conversational);
        return new InterfaceBrowser<ServiceObject>(parent, (ProjectFilter)filter, conversational.getProject());
    }

    public static InterfaceBrowser<ReferenceObject> createConverationReferenceBrowser(@NotNull UiContainer parent, @NotNull Project project) {
        UseInterfaceConversationDefinitionFilter filter = new UseInterfaceConversationDefinitionFilter();
        return new InterfaceBrowser<ReferenceObject>(parent, (ProjectFilter)filter, project);
    }

    public static InterfaceBrowser<ReferenceObject> createConverationalReferenceBrowser(@NotNull UiContainer parent, @NotNull Conversational conversational) {
        UseInterfaceConversationalDefinitionFilter filter = new UseInterfaceConversationalDefinitionFilter(conversational);
        return new InterfaceBrowser<ReferenceObject>(parent, (ProjectFilter)filter, conversational.getProject());
    }

    private void init() {
        LabelProvider.Default labelProvider = new LabelProvider.Default<T>(){

            public String getText(T element) {
                return element.getName();
            }
        };
        this.setLabelProvider(labelProvider);
        this.setBrowserTitle(DesignerMsg.SERVICE);
    }

    private static class UseInterfaceConversationDefinitionFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private UseInterfaceConversationDefinitionFilter() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                Project project = (Project)object;
                result = ConversationalHelper.getConversationReferences((Project)project);
            }
            return result;
        }
    }

    private static class UseInterfaceConversationalDefinitionFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private Conversational conversational;

        private UseInterfaceConversationalDefinitionFilter(@NotNull Conversational conversational) {
            this.conversational = conversational;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                result = ConversationalHelper.getConversationalReferences((Conversational)this.conversational);
            }
            return result;
        }
    }

    private static class ServiceCallConversationDefinitionFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ServiceCallConversationDefinitionFilter() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                Project project = (Project)object;
                result = ConversationalHelper.getConversationServices((Project)project);
            }
            return result;
        }
    }

    private static class ServiceCallConversationalDefinitionFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private Conversational conversational;

        private ServiceCallConversationalDefinitionFilter(@NotNull Conversational conversational) {
            this.conversational = conversational;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                result = ConversationalHelper.getConversationalServices((Conversational)this.conversational);
            }
            return result;
        }
    }
}

