/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ConversationDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.DefineInterfaceConversationDefinition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefineInterfaceConversationDefinitionPanel
extends ConversationDefinitionPanel {
    private CheckBox soapServiceExposedCheckbox;

    public DefineInterfaceConversationDefinitionPanel(@NotNull UiContainer parent, @NotNull ConversationContainer container) {
        super(parent, container, DesignerMsg.DEFINITION);
        this.init();
    }

    @Override
    public void applyDefinition(@NotNull ConversationDefinition conversationDefinition) {
        DefineInterfaceConversationDefinition defineInterfaceConversationDefinition = (DefineInterfaceConversationDefinition)conversationDefinition;
        defineInterfaceConversationDefinition.setSoapServiceExposed(this.soapServiceExposedCheckbox.isSelected());
    }

    @Override
    public void loadDefinition(@NotNull ConversationDefinition conversationDefinition) {
        DefineInterfaceConversationDefinition defineInterfaceConversationDefinition = (DefineInterfaceConversationDefinition)conversationDefinition;
        this.soapServiceExposedCheckbox.setSelected(defineInterfaceConversationDefinition.isSoapServiceExposed());
    }

    @Override
    protected Msg validateInput(@Nullable Conversation conversation) {
        return null;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        this.soapServiceExposedCheckbox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.EXPOSE_AS_SOAP_SERVICE);
        this.add((UiComponent)this.soapServiceExposedCheckbox, "growx");
        this.soapServiceExposedCheckbox.setSelected(true);
    }
}

