/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ConversationDefinitionPanel;
import oracle.bpm.designer.conversation.DefineInterfaceConversationDefinitionPanel;
import oracle.bpm.designer.conversation.ProcessCallConversationDefinitionPanel;
import oracle.bpm.designer.conversation.ServiceCallConversationDefinitionPanel;
import oracle.bpm.designer.conversation.UseInterfaceConversationDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ObjectEditorDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationDialog
extends ObjectEditorDialog<Conversation> {
    private ConversationContainer container;
    private ConversationDefinitionPanel definitionPanel;
    private IdentifierTextField nameTextField;
    private ComboBox<ConversationType> typeComboBox;

    public ConversationDialog(@NotNull UiWindow parent, @NotNull ConversationContainer container, @Nullable Conversation conversation) {
        super(parent, DesignerMsg.CONVERSATION, (Object)conversation);
        this.container = container;
    }

    protected Msg validateInput() {
        String name = this.nameTextField.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.DYNAMIC_NOT_NULL(DesignerMsg.NAME);
        }
        if (ConversationalHelper.conversationNameExists((String)name, (ConversationContainer)this.container, (Conversation)((Conversation)this.getObject()))) {
            return DesignerMsg.DYNAMIC_ALREADY_DEFINED(DesignerMsg.CONVERSATION);
        }
        return this.definitionPanel.validateInput((Conversation)this.getObject());
    }

    protected void setObjectFromEditor(@NotNull Conversation object) {
        String name = this.nameTextField.getText();
        object.setName(name);
        object.setConversationType((ConversationType)this.typeComboBox.getSelectedItem());
        ConversationDefinition definition = object.getConversationDefinition();
        this.definitionPanel.applyDefinition(definition);
    }

    protected Conversation createObjectFromEditor() {
        String name = this.nameTextField.getText();
        ConversationType type = (ConversationType)this.typeComboBox.getSelectedItem();
        Conversation result = this.container.createNamedConversation(name, type);
        ConversationDefinition definition = result.getConversationDefinition();
        this.definitionPanel.applyDefinition(definition);
        return result;
    }

    protected void setEditorFromObject(@NotNull Conversation object) {
        this.nameTextField.setText(object.getName());
        this.typeComboBox.setSelectedItem((Object)object.getConversationType());
        this.definitionPanel.loadDefinition(object.getConversationDefinition());
    }

    protected void setEditorDefaultValues() {
        this.nameTextField.setText(ConversationalHelper.getDefaultConversationName((ConversationContainer)this.container));
        this.typeComboBox.setSelectedItem((Object)ConversationType.DEFAULT);
    }

    protected void layoutControls(final @NotNull UiContainer container) {
        container.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)ProjectDrawMsg.NAME));
        this.nameTextField = new IdentifierTextField(container, 30, true);
        this.nameTextField.setTextLimit(30);
        container.add((UiComponent)this.nameTextField, (Object)"growx, pushx, wrap");
        container.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.TYPE));
        this.typeComboBox = UiFactory.createComboBox((UiContainer)container);
        for (ConversationType conversationType : ConversationType.values()) {
            this.typeComboBox.addItem((Object)conversationType);
        }
        this.typeComboBox.setLabelProvider((LabelProvider)new LabelProvider<ConversationType>(){

            public Image getIcon(ConversationType element) {
                return Image.create((Msg)element.getMsg());
            }

            public String getText(ConversationType element) {
                return element.getMsg().getString();
            }
        });
        this.typeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ConversationDialog.this.rebuildDefinition(container);
            }
        });
        container.add(this.typeComboBox, (Object)"growx, spanx, wrap");
        this.rebuildDefinition(container);
        this.setSize(420, 180);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void rebuildDefinition(@NotNull UiContainer parent) {
        ConversationType type;
        if (this.definitionPanel != null) {
            this.definitionPanel.getParent().remove((UiComponent)this.definitionPanel);
        }
        this.definitionPanel = (type = (ConversationType)this.typeComboBox.getSelectedItem()) == ConversationType.DEFINE_INTERFACE ? new DefineInterfaceConversationDefinitionPanel(parent, this.container) : (type == ConversationType.USE_INTERFACE ? new UseInterfaceConversationDefinitionPanel(parent, this.container) : (type == ConversationType.PROCESS_CALL ? new ProcessCallConversationDefinitionPanel(parent, this.container) : (type == ConversationType.SERVICE_CALL ? new ServiceCallConversationDefinitionPanel(parent, this.container) : null)));
        if (this.definitionPanel != null) {
            parent.add((UiComponent)this.definitionPanel, (Object)"grow, spanx");
        }
        this.revalidate();
    }
}

