/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.BpmnControllerFactory;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public class SingleProcessRootController
extends ControllerImpl.RootController {
    private ProcessController single;

    private SingleProcessRootController(@NotNull ProcessDomain domain, @NotNull DrawableImpl.DrawableRoot drawable) {
        super((Domain)domain, drawable);
    }

    public static SingleProcessRootController create(@NotNull PaintCanvas canvas, @NotNull ProcessDomain domain) {
        DrawableSingleProcessRoot drawable = DrawableSingleProcessRoot.create((PaintCanvas)canvas, (DiagramContext)domain.getContext());
        SingleProcessRootController controller = new SingleProcessRootController(domain, (DrawableImpl.DrawableRoot)drawable);
        controller.refresh();
        return controller;
    }

    @NotNull
    public ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }

    public DrawableSingleProcessRoot getDrawableRoot() {
        return (DrawableSingleProcessRoot)this.getDrawableObject();
    }

    public void addChild(@NotNull Controller controller) {
        if (controller.getDrawableObject().getLayer().equals((Object)DesignerLayer.PROCESS)) {
            this.single = (ProcessController)controller;
        }
        super.addChild(controller);
    }

    public void removeChild(@NotNull Controller controller) {
        if (controller.getDrawableObject().getLayer().equals((Object)DesignerLayer.PROCESS) && controller.equals(this.single)) {
            this.single = null;
        }
        super.removeChild(controller);
    }

    public void refresh() {
        ProcessDomain domain = this.getDomain();
        DrawableFactory drawableFactory = domain.getDrawableFactory();
        BpmnControllerFactory controllerFactory = domain.getControllerFactory();
        DrawableProcess drawableProcess = (DrawableProcess)drawableFactory.create(this.getDrawableObject(), (Object)domain.getDomainElement());
        drawableProcess.setInsets(Insets.valueOf(0, 0, 100, 100));
        Controller processController = controllerFactory.create((Controller)this, (Drawable)drawableProcess);
        processController.refresh();
        processController.add();
    }

    @NotNull
    public ProcessController getSingleProcess() {
        if (this.single == null) {
            throw new IllegalStateException("Oooooops!! It's an empty root! No process attached!\n ProcessController in Root hasn't been initialized!");
        }
        return this.single;
    }
}

