/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.awt.geom.Point2D;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BaseTransitionPropertiesDialog;
import oracle.bpm.designer.SequenceFlowPropertiesDialog;
import oracle.bpm.designer.capability.drag.AnchorMoveCapability;
import oracle.bpm.designer.capability.drag.SequenceFlowMultipleSelectionDragCapability;
import oracle.bpm.designer.capability.selection.ParentFlowElementPopUpCapability;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.subcontroller.HighlightConnectionSubcontroller;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.diagram.editor.ConnectionController;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.subcontroller.AnchorSubcontroller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequenceFlowController
extends FlowElementControllerImpl<SequenceFlow>
implements ConnectionController<SequenceFlow> {
    private int simulationNextPercentage = -1;
    private static final Image SIM_BALL_IMAGE = Image.create((Msg)DesignerMsg.SIMULATION_BALL);

    protected SequenceFlowController(@NotNull NodeContainerController<?> container, @NotNull DrawableSequenceFlow drawable) {
        super(container, drawable);
        this.appendAnchor(DrawableUtils.TransitionAnchor.MIDDLE, CapabilityType.MOVE_MIDDLE_ANCHOR);
        this.appendAnchor(DrawableUtils.TransitionAnchor.FROM, CapabilityType.RECONNECT_SOURCE);
        this.appendAnchor(DrawableUtils.TransitionAnchor.TO, CapabilityType.RECONNECT_TARGET);
        HighlightConnectionSubcontroller.appendTo(this);
        this.install((Capability)new SequenceFlowMultipleSelectionDragCapability(this));
    }

    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    @NotNull
    public DrawableSequenceFlow getDrawableObject() {
        return (DrawableSequenceFlow)super.getDrawableObject();
    }

    public String getTooltipMessage() {
        return this.getMessageToShow();
    }

    @Override
    public void drawSimulation(Graphics graphics) {
        DrawContext context = this.getDomain().getContext();
        if (this.getDrawableObject().isHidden()) {
            return;
        }
        if (!AbstractStudioWorkbench.getInstance().isSimulating()) {
            return;
        }
        if (!this.getDomain().isShowAnimation() || this.simulationNextPercentage > 100 || this.simulationNextPercentage < 0) {
            return;
        }
        double perc = (double)this.simulationNextPercentage / 100.0;
        if (perc <= 0.0 || perc >= 100.0) {
            return;
        }
        Point2D p = this.getDrawableObject().getPathPoint(perc);
        double scale = context.getScale();
        Point offset = this.getDrawableObject().getContainer().getAbsoluteOffset();
        double x = p.getX() + (double)offset.getX();
        double y = p.getY() + (double)offset.getY();
        double simBallWidth = SIM_BALL_IMAGE.getWidth();
        double simBallHeight = SIM_BALL_IMAGE.getHeight();
        double ballX = x - simBallWidth / 2.0;
        double ballY = y - simBallHeight / 2.0;
        Ellipse ellipse = new Ellipse((int)ballX, (int)ballY, (int)simBallWidth, (int)simBallHeight);
        Rectangle bounds = ellipse.getBounds();
        if (this.getDrawableObject().getDrawableSource().intersects(bounds) || this.getDrawableObject().getDrawableTarget().intersects(bounds)) {
            return;
        }
        int scaledX = (int)(ballX * scale);
        int scaledY = (int)(ballY * scale);
        int scaledWidth = (int)(simBallWidth * scale);
        int scaledHeight = (int)(simBallHeight * scale);
        graphics.drawImage(SIM_BALL_IMAGE, scaledX, scaledY, scaledWidth, scaledHeight, (UiComponent)this.getDomain().getCanvas());
    }

    public void editProperties() {
        BaseTransitionPropertiesDialog dialog = SequenceFlowPropertiesDialog.createDialog((SequenceFlow)this.getModelObject());
        dialog.setVisible(true);
        boolean accepted = dialog.userAccepted();
        if (!accepted) {
            this.getDomain().getSelectionProvider().clear();
        }
        this.getDomain().getCanvas().repaint();
    }

    public void resetSimulation() {
        this.simulationNextPercentage = -1;
    }

    @Override
    public String toString() {
        return this.getSequenceFlowImpl().getBuiltName();
    }

    public void setSimulationNextPercentage(int step) {
        this.simulationNextPercentage = step;
    }

    @Nullable
    public Controller getSourceController() {
        return this.asController(this.getDrawableObject().getDrawableSource());
    }

    @Nullable
    public Controller getTargetController() {
        return this.asController(this.getDrawableObject().getDrawableTarget());
    }

    private void appendAnchor(@NotNull DrawableUtils.TransitionAnchor anchor, @NotNull CapabilityType capability) {
        AnchorSubcontroller controller = AnchorSubcontroller.appendTo((ConnectionController)this, (DrawableUtils.TransitionAnchor)anchor);
        controller.install((Capability)new AnchorMoveCapability(controller, capability));
        controller.install((Capability)new ParentFlowElementPopUpCapability((CapableController)controller));
    }

    private String getMessageToShow() {
        DrawContext context = this.getDrawContext();
        return "";
    }

    private boolean useEmptyText(TransitionMessageType currentType) {
        return currentType == TransitionMessageType.DESCRIPTION || currentType == TransitionMessageType.NONE;
    }

    private SequenceFlowImpl getSequenceFlowImpl() {
        return (SequenceFlowImpl)this.getModelObject();
    }

    @Nullable
    private Controller asController(@Nullable Drawable drawable) {
        return drawable != null ? this.getContainer().getControllerFor(drawable) : null;
    }
}

