/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.EnumSet;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllersHolder;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeContainerControllerImpl<T extends NodeContainer>
extends FlowElementControllerImpl<T>
implements NodeContainerController<T> {
    protected NodeContainerControllerImpl(Controller container, @NotNull DrawableNodeContainer<T> drawable) {
        super(container, drawable);
    }

    @NotNull
    public ControllersHolder<FlowElementController> getHolder() {
        return super.getHolder();
    }

    @Override
    @NotNull
    public DrawableNodeContainer<T> getDrawableObject() {
        return (DrawableNodeContainer)super.getDrawableObject();
    }

    @Override
    @NotNull
    public Sequence<FlowElementController> getControllersAt(@NotNull DesignerLayer layer) {
        return this.getHolder().getAtLayer(layer);
    }

    @Override
    @NotNull
    public Sequence<FlowElementController> getControllersAt(@NotNull EnumSet<DesignerLayer> layers) {
        return this.getHolder().getAtLayers(layers);
    }

    @Override
    public boolean contains(@NotNull DrawableFlowElement drawable) {
        return this.getHolder().contains((Drawable)drawable);
    }

    @Override
    public boolean contains(@NotNull FlowElement element) {
        return this.getHolder().contains((Object)element);
    }

    public void addChild(@NotNull Controller controller) {
        Drawable drawable = controller.getDrawableObject();
        if (!DesignerLayer.shouldSkipController((DesignerLayer)drawable.getLayer()) && this.getHolder().contains(drawable)) {
            throw new IllegalArgumentException("There's already a controller defined (" + this.getHolder().getControllerFor(drawable) + ") for the given drawable (" + drawable + ")");
        }
        super.addChild(controller);
    }

    public void removeChild(@NotNull Controller controller) {
        Drawable drawable = controller.getDrawableObject();
        if (!DesignerLayer.shouldSkipController((DesignerLayer)drawable.getLayer()) && !this.getHolder().contains(drawable)) {
            throw new IllegalArgumentException("There was no controller defined for the given drawable (" + drawable + ")");
        }
        super.removeChild(controller);
    }

    @Override
    @NotNull
    public FlowElementController asController(@NotNull FlowElement element) {
        FlowElementController result = (FlowElementController)this.getHolder().getControllerFor((Object)element);
        if (result == null) {
            throw new IllegalStateException("Controller for Object: " + element + " not found");
        }
        return result;
    }

    @Override
    @NotNull
    public FlowElementController asController(@NotNull Drawable drawable) {
        FlowElementController result = this.getControllerFor(drawable);
        if (result == null) {
            throw new IllegalStateException("Controller for Drawable: " + drawable + " not found");
        }
        return result;
    }

    @Override
    @Nullable
    public FlowElementController getControllerFor(@NotNull Drawable drawable) {
        return (FlowElementController)this.getHolder().getControllerFor(drawable);
    }

    @Override
    @NotNull
    public FlowElementController createDisposableControllerFor(@NotNull FlowElement element) {
        FlowElementController result;
        try {
            result = this.asController(element);
        }
        catch (IllegalStateException e) {
            result = null;
        }
        if (result == null) {
            DrawableFlowElement drawable;
            try {
                drawable = this.getDrawableObject().asDrawable(element);
            }
            catch (Exception e) {
                drawable = null;
            }
            if (drawable == null) {
                drawable = (DrawableFlowElement)this.getDomain().getDrawableFactory().create(this.getDrawableObject(), (Object)element);
            }
            try {
                result = this.asController((Drawable)drawable);
            }
            catch (Exception e) {
                result = null;
            }
            if (result == null) {
                result = (FlowElementController)this.getDomain().getControllerFactory().create(this, (Drawable)drawable);
            }
        } else {
            System.out.println("CreateDisposableControllerFor result in a simple find, printing stack! (pcolunga)");
            Thread.dumpStack();
        }
        return result;
    }

    @Override
    public void drawSimulation(Graphics g) {
        for (FlowElementController controller : this.getHolder().getControllers().selectInstanceOf(FlowElementController.class)) {
            controller.drawSimulation(g);
        }
        super.drawSimulation(g);
    }
}

