/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.collections.Sequence;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.measurementmark.MeasurementPropertiesAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.draw.DrawableMeasurement;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.processes.Measurement;
import org.jetbrains.annotations.NotNull;

public class MeasurementController
extends FlowElementControllerImpl<Measurement> {
    protected MeasurementController(@NotNull NodeContainerController<?> container, @NotNull DrawableMeasurement drawable) {
        super(container, drawable);
        HighlightSubcontroller.appendTo(this);
    }

    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    public void editProperties() {
        MeasurementPropertiesAction.getInstance().runWithSelection(this.getModelObject());
    }

    public String getTooltipMessage() {
        return this.getHtmlMessage();
    }

    private String getHtmlMessage() {
        if (((Measurement)this.getModelObject()).getMeasurementType() == MeasurementType.STOP) {
            return "<html>" + DesignerMsg.ENDS_MEASUREMENT(((Measurement)this.getModelObject()).getRelatedMeasurement().getId()) + "</html> ";
        }
        if (!((Measurement)this.getModelObject()).getBusinessIndicators().isEmpty()) {
            StringBuilder html = new StringBuilder("<html>" + DesignerMsg.BUSINESS_VARIABLES + ":\n<ul>");
            Sequence businessVariables = ((Measurement)this.getModelObject()).getBusinessIndicators();
            for (ProjectDataObject businessVariable : businessVariables) {
                html.append("<li>").append(businessVariable.getId()).append("</li>");
            }
            html.append("</ul></html>");
            return html.toString();
        }
        return "<html>" + ((Measurement)this.getModelObject()).getLabelMap() + "</html> ";
    }
}

