/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import fuego.simulation.SimulationFlowNodeImpl;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.action.FlowNodePropertiesAction;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.simulation.ActivitySimulationDelegated;
import oracle.bpm.designer.simulation.ActivitySimulationInfoDialog;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.diagram.editor.ConnectionController;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class FlowNodeControllerImpl<T extends FlowNode>
extends FlowElementControllerImpl<T>
implements FlowNodeController<T>,
ActivitySimulationInterface {
    private final ToConnectionControllerMapper mapper;
    private ActivitySimulationDelegated simulation;

    protected FlowNodeControllerImpl(NodeContainerController container, @NotNull DrawableFlowNode<T> drawable) {
        super(container, drawable);
        ExpandCollapseSubcontroller.appendTo(this);
        HighlightSubcontroller.appendTo(this);
        this.mapper = new ToConnectionControllerMapper(container);
        this.simulation = new ActivitySimulationDelegated(this);
    }

    @Override
    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    public void editProperties() {
        FlowNode flowNode = (FlowNode)this.getModelObject();
        if (AbstractStudioWorkbench.getInstance().isSimulating()) {
            ActivitySimulationInfoDialog dialog = new ActivitySimulationInfoDialog(this.getDomain().getCanvas().getOwnerWindow(), flowNode);
            dialog.setVisible(true);
        } else {
            FlowNodePropertiesAction action = FlowNodePropertiesAction.getInstance();
            action.setSelection(this.getDomain().getSelectionProvider().getSelection());
            action.run();
        }
        this.getDomain().getCanvas().repaint();
    }

    public String getTooltipMessage() {
        FlowNode node = (FlowNode)this.getModelObject();
        String documentation = node.getDocumentationMap().getString();
        if (!Str.isEmpty(documentation)) {
            return documentation.trim();
        }
        String description = node.getDefaultDescription();
        if (!Str.isEmpty(description)) {
            return description;
        }
        String typeString = ((FlowNode)this.getModelObject()).getBpmnType().getString() + ": ";
        String titleName = node.getDefaultLabel();
        return (titleName + ": " + typeString).trim();
    }

    @Override
    @NotNull
    public DrawableFlowNode<T> getDrawableNode() {
        return (DrawableFlowNode)this.getDrawableObject();
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getOutgoingConnections() {
        return ((FlowNode)this.getModelObject()).getOutgoingSequenceFlows().map(this.mapper);
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getIncomingConnections() {
        return ((FlowNode)this.getModelObject()).getIncomingSequenceFlows().map(this.mapper);
    }

    @Override
    public void drawSimulation(Graphics g) {
        this.simulation.drawSimulation(g);
    }

    @Override
    public FlowNode getActivity() {
        return (FlowNode)this.getModelObject();
    }

    @Override
    public SimulationFlowNodeImpl getSimulationInfo() {
        return this.simulation.getSimulationInfo();
    }

    @Override
    public void resetSimulation() {
        this.simulation.resetSimulation();
    }

    @Override
    public void updateSimulationValues() {
        this.simulation.updateSimulationValues();
    }

    protected void refreshDrawable() {
        super.refreshDrawable();
        this.refreshConnections();
    }

    protected void refreshConnections() {
        for (ConnectionController connection : this.getIncomingConnections()) {
            if (connection == null) continue;
            connection.refresh();
        }
        for (ConnectionController connection : this.getOutgoingConnections()) {
            if (connection == null) continue;
            connection.refresh();
        }
    }

    static class ToConnectionControllerMapper
    implements Function<SequenceFlow, ConnectionController> {
        private final NodeContainerController container;

        ToConnectionControllerMapper(@NotNull NodeContainerController container) {
            this.container = container;
        }

        @Override
        public ConnectionController eval(@NotNull SequenceFlow sequenceFlow) {
            ConnectionController result = null;
            if (this.container.contains((FlowElement)sequenceFlow)) {
                result = (ConnectionController)this.container.asController((FlowElement)sequenceFlow);
            }
            return result;
        }
    }
}

