/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.CapableControllerImpl;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Graphics;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class FlowElementControllerImpl<T extends FlowElement>
extends CapableControllerImpl<T>
implements FlowElementController<T> {
    private BatchProjectListenerAdapter<FlowElement> listener;

    protected FlowElementControllerImpl(Controller container, @NotNull DrawableFlowElement<T> drawable) {
        super(container, drawable);
        this.install((Capability)new FocusCapability((CapableController)this));
    }

    public void add() {
        this.addProjectObjectListener();
        super.add();
    }

    public void remove() {
        super.remove();
        this.dispose();
    }

    @Override
    @NotNull
    public ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }

    @Override
    @NotNull
    public DrawableFlowElement<T> getDrawableObject() {
        return (DrawableFlowElement)super.getDrawableObject();
    }

    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    @Override
    public void drawSimulation(Graphics graphics) {
    }

    public void dispose() {
        if (this.listener != null) {
            this.getDomain().unregister(this);
            this.listener = null;
        }
        for (Controller controller : this.getControllers()) {
            controller.dispose();
        }
    }

    public String toString() {
        return this.name((FlowElement)this.getModelObject());
    }

    @NotNull
    protected final DrawContext getDrawContext() {
        return this.getDomain().getContext();
    }

    private void addProjectObjectListener() {
        this.listener = new BatchProjectListenerAdapter<FlowElement>(FlowElement.class){

            public void processPostEvents(ProjectEventSet events) {
                boolean mustRefresh = false;
                boolean mustRefreshDrawable = false;
                for (ProjectEvent event : events) {
                    ProjectObject object = event.getProjectObject();
                    if (object.getParentObject() == FlowElementControllerImpl.this.getModelObject()) {
                        mustRefresh = true;
                        break;
                    }
                    if (object != FlowElementControllerImpl.this.getModelObject()) continue;
                    mustRefreshDrawable = true;
                }
                if (mustRefresh) {
                    FlowElementControllerImpl.this.refresh();
                } else if (mustRefreshDrawable) {
                    FlowElementControllerImpl.this.refreshDrawable();
                }
            }
        };
        this.getDomain().register(this);
    }

    private String name(@NotNull FlowElement flowElement) {
        return flowElement.getDefaultLabel() + '(' + flowElement.getId() + ')';
    }
}

