/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerContainer;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerUtils {
    private static final int MIN_INSERTION_DISTANCE = 2500;
    private static final Predicate<FlowElementController> PREDICATE_INSTANCE_OF_FLOW = new Predicate<FlowElementController>(){

        @Override
        public boolean check(@Nullable FlowElementController value) {
            return value instanceof SequenceFlowController;
        }
    };
    private static final Function<FlowElementController, SequenceFlowController> FUNCTION_TO_FLOW = new Function<FlowElementController, SequenceFlowController>(){

        @Override
        public SequenceFlowController eval(FlowElementController value) {
            return (SequenceFlowController)value;
        }
    };

    public static Sequence<FlowElementController> getControllersAtLayersRecursive(@NotNull NodeContainerController<?> container, @NotNull EnumSet<DesignerLayer> layers) {
        SequenceBuilder<FlowElementController> builder = SequenceBuilder.create();
        ControllerUtils.getControllersAtLayersRecursive(container, layers, builder);
        return builder.build();
    }

    @NotNull
    public static NodeContainerController<?> getNodeContainerControllerFor(@NotNull NodeContainerController<?> container, @NotNull FlowElement element) {
        NodeContainerController<?> result = null;
        if (container.contains(element)) {
            result = container;
        } else {
            Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
            for (NodeContainerController inner : containers) {
                try {
                    result = ControllerUtils.getNodeContainerControllerFor(inner, element);
                }
                catch (Exception e) {}
            }
        }
        if (result == null) {
            throw new IllegalStateException("No ControllerContainer found for this element : " + element);
        }
        return result;
    }

    public static SequenceFlowController getClosestTransition(@NotNull FlowNodeController controller, @NotNull NodeContainerController container, @NotNull Point location, boolean shiftDown, boolean recursive, boolean relocate) {
        SequenceFlowController closest;
        SequenceFlowController result = null;
        if (ModelUtils.canBeInsertedInATransition(controller.getModelObject(), (boolean)relocate) && (closest = ControllerUtils.getClosestTransition(ControllerUtils.getFlowControllersForContainer(container, recursive), location, shiftDown)) != null && !((SequenceFlow)closest.getModelObject()).getSource().equals(controller.getModelObject()) && !((SequenceFlow)closest.getModelObject()).getTarget().equals(controller.getModelObject())) {
            result = closest;
        }
        return result;
    }

    public static SequenceFlowController getClosestTransition(@NotNull FlowNodeController controller, @NotNull NodeContainerController container, @NotNull Point location, boolean shiftDown, boolean recursive) {
        location = ControllerUtils.adjustLocation(container, location);
        return ControllerUtils.getClosestTransition(controller, container, location, shiftDown, recursive, shiftDown);
    }

    public static SequenceFlowController getClosestTransition(@NotNull NodeContainerController container, @NotNull Point location, boolean shiftDown, boolean recursive) {
        Sequence<SequenceFlowController> sequenceFlows = ControllerUtils.getFlowControllersForContainer(container, recursive);
        location = ControllerUtils.adjustLocation(container, location);
        return ControllerUtils.getClosestTransition(sequenceFlows, location, shiftDown);
    }

    public static List<FlowElementController> getControllersAt(@NotNull ControllerContainer container, @NotNull Rectangle bounds) {
        ArrayList<FlowElementController> result = new ArrayList<FlowElementController>();
        Predicate<FlowElementController> check = new Predicate<FlowElementController>(){

            @Override
            public boolean check(FlowElementController controller) {
                DesignerLayer layer = controller.getDrawableObject().getLayer();
                return !DesignerLayer.shouldSkipController((DesignerLayer)layer) && !layer.equals((Object)DesignerLayer.LANE_NAME) && !layer.equals((Object)DesignerLayer.PROCESS) && !layer.equals((Object)DesignerLayer.LANE_COLUMN);
            }
        };
        ControllerUtils.getControllersAt(container, check, bounds, result);
        return result;
    }

    public static FlowElementController createFlowElementControllerFromType(@NotNull FlowFigureType type, @NotNull ProcessDomain domain) {
        Process process = domain.getDomainElement();
        Object element = type.getType().isArtifact() ? FlowFigureUtils.createArtifactFromFigureType((FlowFigureType)type, (NodeContainer)process) : FlowFigureUtils.createNodeFromFigureType((FlowFigureType)type, (NodeContainer)process);
        FlowElementController controller = domain.getCanvas().getProcessController().createDisposableControllerFor((FlowElement)element);
        domain.getCanvas().repaint();
        return controller;
    }

    private static Point adjustLocation(NodeContainerController container, Point location) {
        Point drawableLocation = container.getDrawableObject().getAbsoluteOffset().sub(24, 24);
        location = location.sub(drawableLocation);
        return location;
    }

    private static SequenceFlowController getClosestTransition(@NotNull Sequence<SequenceFlowController> drawableFlows, @NotNull Point location, boolean shiftDown) {
        SequenceFlowController closest = null;
        double minDistance = shiftDown ? 2.147483647E9 : 2500.0;
        for (SequenceFlowController flowController : drawableFlows) {
            DrawableSequenceFlow drawableFlow = flowController.getDrawableObject();
            if (drawableFlow.isHidden()) continue;
            double distance0 = drawableFlow.getPathPoint(0.5).distanceSq(location.getX(), location.getY());
            double distance1 = drawableFlow.getPathPoint(0.25).distanceSq(location.getX(), location.getY());
            double distance2 = drawableFlow.getPathPoint(0.75).distanceSq(location.getX(), location.getY());
            double distance = Math.min(Math.min(distance0, distance1), distance2);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closest = flowController;
        }
        return closest;
    }

    private static List<FlowElementController> getControllersAt(@NotNull ControllerContainer container, @NotNull Predicate<FlowElementController> check, @NotNull Rectangle bounds, @NotNull List<FlowElementController> result) {
        for (Controller child : container.getControllers()) {
            if (!(child instanceof FlowElementController)) continue;
            FlowElementController controller = (FlowElementController)child;
            if (controller instanceof NodeContainerController) {
                Point offset = controller.getDrawableObject().getBounds().getOrigin().flip();
                ControllerUtils.getControllersAt((ControllerContainer)child, check, bounds.translate(offset), result);
            }
            if (!check.check(controller) || !controller.getDrawableObject().intersects(bounds)) continue;
            result.add(controller);
        }
        return result;
    }

    private static void getControllersAtLayersRecursive(@NotNull NodeContainerController<?> container, @NotNull EnumSet<DesignerLayer> layers, @NotNull SequenceBuilder<FlowElementController> result) {
        result.append(container.getControllersAt(layers));
        Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
        for (NodeContainerController inner : containers) {
            ControllerUtils.getControllersAtLayersRecursive(inner, layers, result);
        }
    }

    private static Sequence<SequenceFlowController> getFlowControllersForContainer(@NotNull NodeContainerController<?> container, boolean recursive) {
        SequenceBuilder<SequenceFlowController> flows = SequenceBuilder.create(container.getControllersAt(DesignerLayer.TRANSITION).select(PREDICATE_INSTANCE_OF_FLOW).map(FUNCTION_TO_FLOW));
        if (recursive) {
            Sequence<NodeContainerController> containers = CollectionUtils.selectInstanceOf(container.getControllers(), NodeContainerController.class);
            for (NodeContainerController inner : containers) {
                flows.append(ControllerUtils.getFlowControllersForContainer(inner, recursive));
            }
        }
        return flows.build();
    }

    private static class ToFlowController
    implements Function<SequenceFlow, SequenceFlowController> {
        private NodeContainerController container;

        private ToFlowController(NodeContainerController container) {
            this.container = container;
        }

        @Override
        public SequenceFlowController eval(SequenceFlow sequenceFlow) {
            return (SequenceFlowController)this.container.asController((FlowElement)sequenceFlow);
        }
    }
}

