/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.capability.ConnectionVisuals;
import oracle.bpm.designer.capability.add.ContainerAddMeasurementCapability;
import oracle.bpm.designer.capability.add.ContainerAddingSequenceFlowCapability;
import oracle.bpm.designer.capability.add.ProcessAddNodeCapability;
import oracle.bpm.designer.capability.add.ProcessAddNoteCapability;
import oracle.bpm.designer.capability.add.SubprocessAddNodeCapability;
import oracle.bpm.designer.capability.drag.EventMoveCapability;
import oracle.bpm.designer.capability.drag.LaneMoveCapability;
import oracle.bpm.designer.capability.drag.MeasurementMoveCapability;
import oracle.bpm.designer.capability.drag.NodeMoveCapability;
import oracle.bpm.designer.capability.drag.NoteMoveCapability;
import oracle.bpm.designer.capability.drag.ProcessMarqueeCapability;
import oracle.bpm.designer.capability.drag.ProcessPanningCapability;
import oracle.bpm.designer.capability.edit.ProcessEditCapability;
import oracle.bpm.designer.capability.selection.FlowElementPopUpCapability;
import oracle.bpm.designer.capability.selection.ProcessPopUpCapability;
import oracle.bpm.designer.capability.selection.ProcessSelectionCapability;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.EventController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.GatewayController;
import oracle.bpm.designer.controller.LaneController;
import oracle.bpm.designer.controller.MeasurementController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.controller.SubprocessController;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabelable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerCreator;
import oracle.bpm.diagram.editor.ControllerListener;
import oracle.bpm.diagram.editor.GenericControllerFactory;
import oracle.bpm.diagram.editor.LabelController;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.edit.ElementEditCapability;
import oracle.bpm.diagram.editor.capability.edit.LabelInplaceEditCapability;
import oracle.bpm.diagram.editor.capability.selection.ElementSelectionCapability;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableGateway;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.draw.DrawableMeasurement;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableNote;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.project.command.design.ChangeFlowElementLabelCommand;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

public class BpmnControllerFactory
extends GenericControllerFactory {
    private static BpmnControllerFactory instance;

    protected BpmnControllerFactory() {
        this.creators();
    }

    public static BpmnControllerFactory getInstance() {
        if (instance == null) {
            instance = new BpmnControllerFactory();
        }
        return instance;
    }

    protected void creators() {
        this.creator(this.processCreator());
        this.creator(this.measurementCreator());
        this.creator(this.laneCreator());
        this.creator(this.noteCreator());
        this.creator(this.flowCreator());
        this.creator(this.subprocessCreator());
        this.creator(this.eventCreator());
        this.creator(this.gatewayCreator());
        this.creator(this.activityCreator());
    }

    protected ControllerCreator processCreator() {
        return new ControllerCreator<DrawableProcess>(DrawableProcess.class){

            protected Controller create(@NotNull Controller container, @NotNull DrawableProcess drawable) {
                ProcessController controller = new ProcessController(container, drawable);
                controller.install((Capability)new ProcessMarqueeCapability(controller));
                controller.install((Capability)new ProcessPanningCapability(controller));
                controller.install(new ProcessSelectionCapability(controller));
                controller.install(new ProcessPopUpCapability(controller));
                controller.install(new ProcessEditCapability(controller));
                controller.install((Capability)new ProcessAddNodeCapability(controller));
                controller.install((Capability)new ProcessAddNoteCapability(controller));
                controller.install((Capability)new ContainerAddMeasurementCapability(controller));
                controller.install((Capability)new ContainerAddingSequenceFlowCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator measurementCreator() {
        return new NodeContainerCreator<DrawableMeasurement>(DrawableMeasurement.class){

            @Override
            protected Controller create(@NotNull NodeContainerController container, @NotNull DrawableMeasurement drawable) {
                MeasurementController controller = new MeasurementController(container, drawable);
                controller.install((Capability)new MeasurementMoveCapability(controller));
                controller.install((Capability)new ElementEditCapability((CapableController)controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                controller.install((Capability)new FlowElementPopUpCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator laneCreator() {
        return new NodeContainerCreator<DrawableLaneName>(DrawableLaneName.class){

            @Override
            protected Controller create(@NotNull NodeContainerController container, @NotNull DrawableLaneName drawable) {
                LaneController controller = new LaneController(container, drawable);
                controller.install((Capability)new LaneMoveCapability(controller));
                controller.install((Capability)new ElementEditCapability((CapableController)controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                controller.install((Capability)new FlowElementPopUpCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator noteCreator() {
        return new NodeContainerCreator<DrawableNote>(DrawableNote.class){

            @Override
            protected Controller create(@NotNull NodeContainerController container, @NotNull DrawableNote drawable) {
                NoteController controller = new NoteController(container, drawable);
                controller.install((Capability)new NoteMoveCapability(controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                controller.install((Capability)new FlowElementPopUpCapability(controller));
                controller.install((Capability)new ElementEditCapability((CapableController)controller));
                return controller;
            }
        };
    }

    protected ControllerCreator flowCreator() {
        return new NodeContainerCreator<DrawableSequenceFlow>(DrawableSequenceFlow.class){

            @Override
            protected Controller create(@NotNull NodeContainerController container, @NotNull DrawableSequenceFlow drawable) {
                return new SequenceFlowController(container, drawable);
            }
        };
    }

    protected ControllerCreator subprocessCreator() {
        return new NodeContainerCreator<DrawableSubprocess>(DrawableSubprocess.class){

            @Override
            protected Controller create(@NotNull NodeContainerController container, @NotNull DrawableSubprocess drawable) {
                SubprocessController controller = new SubprocessController(container, drawable);
                controller.install((Capability)new ElementEditCapability((CapableController)controller));
                controller.install((Capability)new FlowElementPopUpCapability(controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                controller.install((Capability)new NodeMoveCapability(controller));
                controller.install((Capability)new SubprocessAddNodeCapability(controller));
                controller.install((Capability)new ContainerAddMeasurementCapability(controller){

                    public void showTargetVisuals(@NotNull CapabilityEvent event) {
                        DrawableNodeContainer drawable = this.getController().getDrawableObject();
                        if (!drawable.isShowFocus()) {
                            drawable.setShowFocus(true);
                        }
                        super.showTargetVisuals(event);
                    }

                    public void eraseTargetVisuals(@NotNull CapabilityEvent event) {
                        this.getController().getDrawableObject().setShowFocus(false);
                        super.eraseTargetVisuals(event);
                    }

                    @Override
                    protected ConnectionVisuals createConnectionVisuals() {
                        return new ConnectionVisuals(true);
                    }
                });
                controller.install((Capability)new ContainerAddingSequenceFlowCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator eventCreator() {
        return new FlowNodeCreator<DrawableEvent>(DrawableEvent.class){

            @Override
            protected FlowNodeController subtype(@NotNull NodeContainerController container, @NotNull DrawableEvent drawable) {
                EventController controller = new EventController(container, drawable);
                controller.install((Capability)new EventMoveCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator gatewayCreator() {
        return new FlowNodeCreator<DrawableGateway>(DrawableGateway.class){

            @Override
            protected FlowNodeController subtype(@NotNull NodeContainerController container, @NotNull DrawableGateway drawable) {
                GatewayController controller = new GatewayController(container, drawable);
                controller.install((Capability)new NodeMoveCapability(controller));
                return controller;
            }
        };
    }

    protected ControllerCreator activityCreator() {
        return new FlowNodeCreator<DrawableActivity>(DrawableActivity.class){

            @Override
            protected FlowNodeController subtype(@NotNull NodeContainerController container, @NotNull DrawableActivity drawable) {
                ActivityController controller = new ActivityController(container, drawable);
                controller.install((Capability)new NodeMoveCapability(controller));
                return controller;
            }
        };
    }

    private static abstract class DrawableLabelableCreator<T extends Drawable>
    extends ControllerCreator<T> {
        private DrawableLabelableCreator(@NotNull Class<T> clazz) {
            super(clazz);
        }

        protected abstract Controller innerCreate(@NotNull Controller var1, @NotNull T var2);

        protected Controller create(@NotNull Controller container, @NotNull T drawable) {
            final Controller controller = this.innerCreate(container, drawable);
            if (drawable instanceof DrawableLabelable) {
                DrawableLabelable labelable = (DrawableLabelable)controller.getDrawableObject();
                final LabelController labelController = new LabelController(controller);
                labelController.install((Capability)new LabelInplaceEditCapability((CapableController)controller, labelable.getLabel()){

                    protected void setModelObjectNewLabel(@NotNull String label) {
                        ChangeFlowElementLabelCommand command = new ChangeFlowElementLabelCommand((FlowElement)controller.getModelObject(), label);
                        ActionRunner.getInstance().run((Command)command);
                    }
                });
                controller.addControllerListener((ControllerListener)new ControllerListener.Default(){

                    public void added(@NotNull Controller controller) {
                        labelController.add();
                    }

                    public void removed(@NotNull Controller controller) {
                        labelController.remove();
                    }
                });
            }
            return controller;
        }
    }

    protected static abstract class NodeContainerCreator<T extends Drawable>
    extends DrawableLabelableCreator<T> {
        protected NodeContainerCreator(@NotNull Class<T> clazz) {
            super(clazz);
        }

        protected abstract Controller create(@NotNull NodeContainerController var1, @NotNull T var2);

        @Override
        protected Controller innerCreate(@NotNull Controller container, @NotNull T drawable) {
            return this.create((NodeContainerController)container, drawable);
        }

        protected boolean check(@NotNull Controller container, @NotNull T drawable) {
            return container instanceof NodeContainerController;
        }
    }

    protected static abstract class FlowNodeCreator<T extends DrawableFlowNode>
    extends NodeContainerCreator<T> {
        protected FlowNodeCreator(@NotNull Class<T> clazz) {
            super(clazz);
        }

        protected abstract FlowNodeController subtype(@NotNull NodeContainerController var1, @NotNull T var2);

        @Override
        protected Controller create(@NotNull NodeContainerController container, @NotNull T drawable) {
            FlowNodeController subtype = this.subtype(container, drawable);
            subtype.install((Capability)new ElementEditCapability((CapableController)subtype));
            subtype.install((Capability)new ElementSelectionCapability((CapableController)subtype));
            subtype.install((Capability)new FlowElementPopUpCapability(subtype));
            return subtype;
        }
    }
}

