/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.RemoveActivityCommand;
import oracle.bpm.project.command.design.RemoveLaneCommand;
import oracle.bpm.project.command.design.RemoveMeasurementCommand;
import oracle.bpm.project.command.design.RemoveNoteCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.ui.ModelObjectSelection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveObjectsCommand
extends MultipleCommand {
    @NotNull
    private final Collection<FlowElement> modelObjects;

    public RemoveObjectsCommand(@NotNull ModelObjectSelection modelObjects) {
        super(new ProjectObject[]{(ProjectObject)modelObjects.as(ProjectObject.class)});
        this.modelObjects = modelObjects.normalizeForRemove();
        this.build();
    }

    public RemoveObjectsCommand(@NotNull Collection<FlowElement> modelObjects) {
        super((ProjectObject[])modelObjects.toArray(new FlowElement[modelObjects.size()]));
        this.modelObjects = modelObjects;
        this.build();
    }

    public Object execute() throws ExecutionException {
        return super.execute();
    }

    public String getName() {
        return ProjectCommandMsg.REMOVE.getString();
    }

    private static void purgeCommands(MultipleCommand multipleCommand, HashSet<CommandKey> commandKeys) {
        Iterator iterator = multipleCommand.getCommands().iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            CommandKey commandKey = CommandKey.valueOf(command);
            if (commandKeys.contains(commandKey)) {
                iterator.remove();
                continue;
            }
            commandKeys.add(commandKey);
            if (!(command instanceof MultipleCommand)) continue;
            RemoveObjectsCommand.purgeCommands((MultipleCommand)command, commandKeys);
        }
    }

    private void build() {
        Collection<FlowElement> flowElements = this.modelObjects;
        Iterable<Measurement> measurementIterable = CollectionUtils.selectInstanceOf(this.modelObjects, Measurement.class);
        for (Measurement measurement : measurementIterable) {
            this.addCommand((Command)new RemoveMeasurementCommand(measurement));
        }
        Iterable<SequenceFlow> sequenceFlowIterable = CollectionUtils.selectInstanceOf(this.modelObjects, SequenceFlow.class);
        for (SequenceFlow sequenceFlow : sequenceFlowIterable) {
            this.addCommand((Command)new RemoveTransitionCommand(sequenceFlow));
        }
        Sequence<FlowElement> flowElementSequence = CollectionUtils.select(this.modelObjects, new Predicate<FlowElement>(){

            @Override
            public boolean check(@Nullable FlowElement value) {
                return !(value instanceof Measurement) && !(value instanceof SequenceFlow);
            }
        });
        for (FlowElement flowElement : flowElementSequence) {
            if (flowElement instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)flowElement;
                this.addCommand((Command)new RemoveActivityCommand(flowNode));
                continue;
            }
            if (flowElement instanceof Lane) {
                Lane lane = (Lane)flowElement;
                this.addCommand((Command)new RemoveLaneCommand(lane));
                continue;
            }
            if (!(flowElement instanceof TextAnnotation)) continue;
            TextAnnotation textAnnotation = (TextAnnotation)flowElement;
            this.addCommand((Command)new RemoveNoteCommand(textAnnotation));
        }
    }

    private static class CommandKey {
        private Object affectedObject;
        private String name;

        private CommandKey(String name, Object affectedObject) {
            this.name = name;
            this.affectedObject = affectedObject;
        }

        public static CommandKey valueOf(Command command) {
            return new CommandKey(command.getName(), command.getAffectedObject());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandKey that = (CommandKey)o;
            if (this.affectedObject != null ? !this.affectedObject.equals(that.affectedObject) : that.affectedObject != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.affectedObject != null ? this.affectedObject.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

