/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.command.design.ResizeLaneCommand;
import oracle.bpm.project.command.design.SwitchLaneCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnsureLaneCommand
extends MultipleCommand {
    private final Point destination;
    private final AddLaneAction.LaneInfo info;
    private final Process process;

    public EnsureLaneCommand(@NotNull Point destination, @NotNull FlowNode flowNode, @Nullable AddLaneAction.LaneInfo info) {
        super(new ProjectObject[]{flowNode});
        this.destination = destination;
        this.info = info;
        this.process = flowNode.getProcess();
        this.build();
    }

    public static boolean needsNewLane(@NotNull Point destination, @NotNull FlowNode flowNode) {
        Lane target = LaneUtils.getLane((Process)flowNode.getProcess(), (Point)destination);
        boolean hasLane = ModelUtils.hasLane((FlowNode)flowNode);
        return hasLane && (target == null || target.isAutomatic());
    }

    public String getName() {
        return DesignerMsg.EMPTY_MSG("").toString();
    }

    public FlowNode getAffectedObject() {
        return (FlowNode)super.getAffectedObject();
    }

    private void build() {
        FlowNode flowNode = this.getAffectedObject();
        Lane target = LaneUtils.getLane((Process)this.process, (Point)this.destination);
        Lane last = LaneUtils.getLastLane((Process)this.process);
        boolean hasLane = ModelUtils.hasLane((FlowNode)flowNode);
        if (hasLane) {
            if (target == null || target.isAutomatic()) {
                if (target == null) {
                    if (last.isAutomatic()) {
                        this.addCommand((Command)new ResizeLaneCommand(last, this.getNewSizeForLastLane(last)));
                        this.addCommand((Command)new SwitchLaneCommand(last, this.info.getRoleId(), this.info.getBackgroundColor()));
                    } else if (last.getRole().equals(this.info.getRoleId())) {
                        this.addCommand((Command)new ResizeLaneCommand(last, this.getNewSizeForLastLane(last)));
                    } else {
                        this.addCommand((Command)new AddLaneCommand(this.process, this.info.getRoleId(), this.info.getBackgroundColor(), last.getOffset() + last.getSize()));
                    }
                } else {
                    this.addCommand((Command)new SwitchLaneCommand(last, this.info.getRoleId(), this.info.getBackgroundColor(), this.info.getCustomImage()));
                }
            }
        } else if (target == null) {
            this.addCommand((Command)new ResizeLaneCommand(last, this.getNewSizeForLastLane(last)));
        }
    }

    private int getNewSizeForLastLane(@NotNull Lane last) {
        return this.getMinimumOffset() + 50 - last.getOffset();
    }

    private int getMinimumOffset() {
        FlowNode flowNode = this.getAffectedObject();
        return ModelUtils.isHorizontal((Process)this.process) ? this.destination.getY() + flowNode.getHeight() : this.destination.getX() + flowNode.getWidth();
    }
}

