/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import java.util.Collection;
import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.command.CreateModelWithSelectionCommand;
import oracle.bpm.designer.command.RemoveObjectsCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.design.ChangeTransitionSourceCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.features.RelatedBPMNProcessFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;

public class CreateSubProcessCommand
extends MultipleCommand {
    private Process currentModel;
    private FolderContainer modelContainer;
    private ModelObjectSelection processSelectionRectangle;
    private Point targetLocation;
    private Process targetModel;

    public CreateSubProcessCommand(Process mutable, FolderContainer modelContainer, Point targetLocation, ModelObjectSelection processSelectionRectangle) {
        super(new ProjectObject[0]);
        this.targetModel = mutable;
        this.modelContainer = modelContainer;
        this.targetLocation = targetLocation;
        this.processSelectionRectangle = processSelectionRectangle;
        this.currentModel = null;
        this.build();
    }

    public String getName() {
        return DesignerMsg.CREATE_SUBPROCESS_WITH_SELECTION.getString();
    }

    public ProjectObject getAffectedObject() {
        return this.currentModel;
    }

    private void build() {
        Activity subActivity = this.currentModel.createActivity();
        subActivity.setDefaultLabel(ModelUtils.nextLabelForActivity((NodeContainer)this.currentModel, (String)BpmnType.SUBPROCESS.getLabel().getString()));
        subActivity.toCallActivity();
        subActivity.setDefaultDescription(subActivity.getDefaultLabel());
        RelatedBPMNProcessFeature relatedProcessFeature = (RelatedBPMNProcessFeature)subActivity.getFeature(RelatedBPMNProcessFeature.class);
        relatedProcessFeature.getTargetModelName().setValue(this.targetModel.getId());
        this.addCommand((Command)((Object)new CreateModelWithSelectionCommand(this.targetModel, this.modelContainer, this.targetLocation, this.processSelectionRectangle)));
        this.addCommand((Command)((Object)new RemoveObjectsCommand(this.processSelectionRectangle)));
        this.addCommand((Command)new AddActivityCommand((FlowNode)subActivity, ModelUtils.getRectangle((List)this.processSelectionRectangle.getPositionals()).getCenter()));
        List<SequenceFlow> incomingTransitions = DesignerUtils.getIncomingTransitions(this.processSelectionRectangle);
        Collection<SequenceFlow> outgoingTransitions = DesignerUtils.getOutgoingTransitions(this.processSelectionRectangle);
        for (SequenceFlow incomingTransition : incomingTransitions) {
            this.addCommand((Command)new AddTransitionCommand(incomingTransition));
            this.addCommand((Command)new ChangeTransitionTargetCommand(incomingTransition, (FlowNode)subActivity));
        }
        for (SequenceFlow outgoingTransition : outgoingTransitions) {
            this.addCommand((Command)new AddTransitionCommand(outgoingTransition));
            this.addCommand((Command)new ChangeTransitionSourceCommand(outgoingTransition, (FlowNode)subActivity));
        }
    }
}

