/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.command.Command;
import oracle.bpm.designer.command.PasteCopiedObjectsCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.CreateModelCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.ui.ModelObjectSelection;

public class CreateModelWithSelectionCommand
extends MultipleCommand {
    private Process model;
    private FolderContainer modelContainer;
    private ModelObjectSelection objects;
    private Point point;

    public CreateModelWithSelectionCommand(Process model, FolderContainer modelContainer, Point point, ModelObjectSelection objects) {
        super(new ProjectObject[]{model.getProject()});
        this.model = model;
        this.modelContainer = modelContainer;
        this.point = point;
        this.objects = objects;
        this.buildCommands();
    }

    public String getName() {
        return DesignerMsg.CREATE_PROCESS_WITH_SELECTION.getString();
    }

    private void buildCommands() {
        this.addCommand((Command)new CreateModelCommand(this.modelContainer, this.model));
        this.addCommand((Command)((Object)new PasteCopiedObjectsCommand(this.model, this.point)));
    }
}

