/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import org.jetbrains.annotations.NotNull;

public class CopyProjectSimulationCommand
extends ProjectCommand {
    private String simulationId;

    public CopyProjectSimulationCommand(@NotNull ProjectSimulation fromProjectSimulation, @NotNull String simulationId) {
        super(new ProjectObject[]{fromProjectSimulation});
        this.simulationId = simulationId;
    }

    public String getName() {
        return DesignerMsg.COPY.getString() + this.getAffectedObject().getClass();
    }

    public Object execute() throws ExecutionException {
        ProjectSimulation simulation = (ProjectSimulation)this.getAffectedObject();
        ProjectObject newSimulation = simulation.copy();
        newSimulation.setId(this.simulationId);
        try {
            ((FolderContainer)this.getAffectedObject().getParentObject()).addChild(newSimulation);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return newSimulation;
    }
}

