/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class CopyProcessCommand
extends ProjectCommand {
    private String description;
    private FolderContainer location;
    private String processName;

    public CopyProcessCommand(@NotNull Process fromProcess, @NotNull FolderContainer location, String processName, String description) {
        super(new ProjectObject[]{fromProcess});
        this.location = location;
        this.processName = processName;
        this.description = description;
    }

    public String getName() {
        return DesignerMsg.COPY.getString() + this.getAffectedObject().getClass();
    }

    public Object execute() throws ExecutionException {
        Process fromProcess = (Process)this.getAffectedObject();
        Process process = (Process)fromProcess.copy();
        process.asMutableLocalizable().setDefaultLabel(this.processName);
        process.asMutableLocalizable().setDefaultDescription(this.description);
        process.setId(ModelUtils.validIdForProcess((Project)fromProcess.getProject(), (String)this.processName));
        ((NamespaceFeature)process.getFeature(NamespaceFeature.class)).setValue("");
        process.setParentObject((ProjectObject)this.location);
        try {
            this.location.addChild((ProjectObject)process);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return process;
    }
}

