/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.command;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;

public class CopyModelSimulationCommand
extends ProjectCommand {
    private String newSimulationName;

    public CopyModelSimulationCommand(ModelSimulation modelSimulation, String newSimulationName) {
        super(new ProjectObject[]{modelSimulation});
        this.newSimulationName = newSimulationName;
    }

    public String getName() {
        return DesignerMsg.COPY.getString() + this.getAffectedObject().getClass();
    }

    public Object execute() throws ExecutionException {
        ModelSimulation modelSimulation = (ModelSimulation)this.getAffectedObject();
        ModelSimulation newModelSimulation = (ModelSimulation)modelSimulation.copy();
        try {
            newModelSimulation.setId(this.newSimulationName);
            ((FolderContainer)modelSimulation.getParentObject()).addChild((ProjectObject)newModelSimulation);
        }
        catch (ProjectException e) {
            new ExecutionException(e);
        }
        return newModelSimulation;
    }
}

