/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationEntity;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationMessage;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.collaboration.CollaborationUniverse;
import org.jetbrains.annotations.NotNull;

public class DrawableCollaborationUniverse
extends DrawableImpl<CollaborationUniverse>
implements Renderer {
    private List<Drawable> entities = new ArrayList<Drawable>();
    private static final int ENTITIES_GAP = 15;
    private static final Predicate<Drawable> INSTANCE_OF_MESSAGE = PredicateUtils.instanceOf(DrawableCollaborationMessage.class);

    public DrawableCollaborationUniverse(Drawable root, @NotNull CollaborationUniverse universe) {
        super(root, (Object)universe, DesignerLayer.ROOT);
        this.attachRenderer(this);
    }

    public void addChild(@NotNull Drawable drawable) {
        super.addChild(drawable);
        if (drawable instanceof DrawableCollaborationEntity) {
            this.getOrderedEntities().add(drawable);
        }
    }

    public void removeChild(@NotNull Drawable drawable) {
        super.removeChild(drawable);
        if (drawable instanceof DrawableCollaborationEntity) {
            this.getOrderedEntities().remove(drawable);
        }
    }

    public void refresh() {
        int width = this.getEntitiesMaxWidth();
        Rectangle bounds = Rectangle.valueOf(Point.ORIGIN, width, 0);
        for (Drawable entity : this.getOrderedEntities()) {
            entity.setWidth(width);
            Point last = bounds.getCenter().translate(0, bounds.getHeight() / 2 + 15);
            entity.setLocation(last.translate(0, entity.getHeight() / 2));
            bounds = bounds.union(entity.getBounds());
        }
        bounds = bounds.expandToPoint(bounds.getTop().translate(0, 15));
        this.setWidth(bounds.getWidth());
        this.setHeight(bounds.getHeight());
        this.setLocation(bounds.getCenter());
        this.refreshDrawableMessages();
        super.refresh();
    }

    public List<Drawable> getOrderedEntities() {
        return this.entities;
    }

    public void refreshDrawableMessages() {
        for (Drawable message : this.getDrawableMessages()) {
            message.refresh();
        }
    }

    public void swapEntities(Drawable original, Drawable swap) {
        this.entities.set(this.entities.indexOf(original), this.entities.set(this.entities.indexOf(swap), original));
    }

    public void render() {
        Graphics graphics = this.getContext().getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(Color.WHITE);
        graphics.fill(graphics.getClipBounds());
        graphics.setForeground(original);
    }

    private Sequence<Drawable> getDrawableMessages() {
        return this.getDrawables().select(INSTANCE_OF_MESSAGE);
    }

    private int getEntitiesMaxWidth() {
        int width = 0;
        for (Drawable entity : this.getOrderedEntities()) {
            width = Math.max(width, entity.getWidth());
        }
        return width;
    }
}

