/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import oracle.bpm.designer.collaboration.draw.DrawableCollaborationEntity;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.collaboration.CollaborationService;
import org.jetbrains.annotations.NotNull;

public class DrawableCollaborationService
extends DrawableCollaborationEntity<CollaborationService>
implements Renderer {
    DrawableCollaborationService(@NotNull Drawable container, @NotNull CollaborationService service) {
        super(container, service);
        this.attachRenderer(this);
    }

    public void refresh() {
        this.setHeight(70);
        super.refresh();
    }

    public void render() {
        Rectangle bounds = this.getContext().scale(this.getBounds());
        Graphics graphics = this.getContext().getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(Color.LIGHT_GRAY);
        graphics.fillRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 10, 10);
        graphics.setForeground(original);
        Font oldFont = graphics.getFont();
        graphics.setFont(this.getContext().scale(oldFont.bold()));
        String label = ((CollaborationService)this.getModelObject()).getBaseEntity().getText();
        int width = graphics.getFontMetrics().stringWidth(label);
        Point center = bounds.getCenter();
        graphics.drawString(label, center.getX() - width / 2, center.getY());
        graphics.setFont(oldFont);
    }
}

