/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import oracle.bpm.designer.collaboration.draw.DrawableCollaborationEntity;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationPoolLabel;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.collaboration.CollaborationProcess;
import org.jetbrains.annotations.NotNull;

public class DrawableCollaborationProcess
extends DrawableCollaborationEntity<CollaborationProcess>
implements Renderer {
    private DrawableCollaborationPoolLabel name;
    public static final int POOL_OFFSET = 10;

    DrawableCollaborationProcess(@NotNull Drawable container, @NotNull CollaborationProcess process) {
        super(container, process);
        this.name = new DrawableCollaborationPoolLabel(container, this);
        this.attachRenderer(this);
    }

    public void refresh() {
        Dimension dimension = this.getChildrenBounds().expand(10).getSize();
        this.setWidth(dimension.getWidth() + 25);
        this.setHeight(dimension.getHeight());
        this.name.refresh();
        super.refresh();
    }

    public void add() {
        super.add();
        this.name.add();
    }

    public void remove() {
        super.remove();
        this.name.remove();
    }

    public void render() {
        Rectangle bounds = this.getContext().scale(this.getBounds());
        Graphics graphics = this.getContext().getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(((CollaborationProcess)this.getModelObject()).isPrincipal() ? Color.FUEGO_LIGHT_BLUE : Color.LIGHT_GRAY);
        graphics.fillRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 10, 10);
        graphics.setForeground(original);
    }

    private Rectangle getChildrenBounds() {
        Rectangle bounds = Rectangle.ZERO;
        for (Drawable child : this.getDrawables()) {
            if (bounds == Rectangle.ZERO) {
                bounds = child.getBounds();
                continue;
            }
            bounds = bounds.union(child.getBounds());
        }
        return bounds;
    }
}

