/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import oracle.bpm.designer.collaboration.draw.DrawableCollaborationProcess;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableVerticalLabel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.geom.Insets;
import oracle.bpm.project.model.collaboration.CollaborationProcess;
import org.jetbrains.annotations.NotNull;

public class DrawableCollaborationPoolLabel
extends DrawableVerticalLabel<CollaborationProcess> {
    private String truncatedLabel;
    public static final int LANE_NAME_GAP = 25;

    public DrawableCollaborationPoolLabel(@NotNull Drawable container, @NotNull DrawableCollaborationProcess owner) {
        super(container, (Drawable)owner, DesignerLayer.PROCESS);
        this.setLabelLocation(DrawableLabel.LabelLocation.CENTER_LEFT);
        this.setHorizontalAlignment(DrawableLabel.HorizontalAlignment.LEFT);
        this.setVerticalAlignment(DrawableLabel.VerticalAlignment.CENTER);
        this.setInsets(Insets.valueOf(0, -5, 0, 0));
    }

    public Font getFont() {
        DrawContext context = this.getContext();
        Font font = context.getTheme().getLaneFont(this.isShowSelection());
        return font.larger(2);
    }

    @NotNull
    public String getLabel() {
        if (this.truncatedLabel == null) {
            String result = ((CollaborationProcess)this.getModelObject()).getBaseEntity().getDefaultLabel();
            return result;
        }
        return this.truncatedLabel;
    }

    public void refresh() {
        this.truncatedLabel = null;
        super.refresh();
    }

    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    protected int calculateLabelHeight(@NotNull String label, @NotNull FontMetrics metrics) {
        int height = metrics.stringWidth(label);
        this.truncatedLabel = label;
        int ownerHeight = this.getOwnerBounds().getHeight() - 10;
        while (height > this.getContext().scale(ownerHeight) && label.length() > 0) {
            label = label.substring(0, label.length() - 1);
            this.truncatedLabel = label + "...";
            height = metrics.stringWidth(this.truncatedLabel);
        }
        return height;
    }

    protected Color getLabelBackgroundColor() {
        return !((CollaborationProcess)this.getModelObject()).isPrincipal() ? Color.LIGHT_GRAY : Color.FUEGO_LIGHT_BLUE;
    }

    protected String getSpecificLabelIdentification() {
        return String.valueOf(((CollaborationProcess)this.getModelObject()).isPrincipal());
    }
}

