/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableConnectionImpl;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.LineStyle;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Elbow;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.collaboration.CollaborationAnchor;
import oracle.bpm.project.model.collaboration.CollaborationMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableCollaborationMessage
extends DrawableConnectionImpl<CollaborationMessage> {
    DrawableCollaborationMessage(Drawable container, @NotNull CollaborationMessage message) {
        super(container, (Object)message, DesignerLayer.ROOT);
        this.setStyle(LineStyle.DASH);
    }

    public void refresh() {
        CollaborationAnchor messageTarget;
        CollaborationMessage message = (CollaborationMessage)this.getModelObject();
        this.setBidirectional(!message.isOneWay());
        Drawable source = this.getContainer().getDrawableFor((Object)message.getSource().getEntity());
        Drawable from = null;
        if (source != null) {
            from = DrawableUtils.findDrawable((Drawable)source, (Object)message.getSource().getElement());
        }
        Drawable target = (messageTarget = message.getTarget()) == null ? null : this.getContainer().getDrawableFor((Object)messageTarget.getEntity());
        Drawable to = null;
        if (target != null) {
            to = DrawableUtils.findDrawable((Drawable)target, (Object)message.getTarget().getElement());
        }
        this.setRoutingData(source, from, target, to);
        super.refresh();
    }

    protected void drawPath(@NotNull Path path) {
        if (path.getBounds().getWidth() != 0.0 || path.getBounds().getHeight() != 0.0) {
            Graphics graphics = this.getContext().getGraphics();
            Stroke s = graphics.getStroke();
            graphics.setStroke(Stroke.TWO_SOLID);
            super.drawPath(path);
            graphics.setStroke(s);
        }
    }

    protected Path createRawPath(@NotNull Point begin, @NotNull Point end) {
        return this.createRawPath(begin, end, Point.ORIGIN);
    }

    protected Color getConnectionColor() {
        return Color.DARK_GRAY;
    }

    private void setRoutingData(Drawable source, @Nullable Drawable from, Drawable target, @Nullable Drawable to) {
        Path dummy;
        Point offset;
        if (from != null) {
            this.setSourceLocation(from.getContainer().getAbsoluteOffset().translate(from.getLocation()));
        } else {
            this.setDrawableSource(source);
        }
        if (to != null) {
            this.setTargetLocation(to.getContainer().getAbsoluteOffset().translate(to.getLocation()));
        } else {
            this.setDrawableTarget(target);
        }
        Path path = this.getPath();
        if (from == null) {
            this.setSourceLocation(new Point(this.getTargetRawLocation().getX(), new Point(path.eval(0.0)).getY()));
        }
        if (to == null) {
            this.setTargetLocation(new Point(this.getSourceRawLocation().getX(), new Point(path.eval(1.0)).getY()));
        }
        if (from != null) {
            offset = from.getContainer().getAbsoluteOffset();
            dummy = this.createRawPath(this.getSourceRawLocation().sub(offset), this.getTargetRawLocation().sub(offset), offset);
            this.setSourceLocation(new Point(dummy.eval(DrawableUtils.outbound((Drawable)from, (Path)dummy, (boolean)true))).add(offset));
        }
        if (to != null) {
            offset = to.getContainer().getAbsoluteOffset();
            dummy = this.createRawPath(this.getSourceRawLocation().sub(offset), this.getTargetRawLocation().sub(offset), offset);
            this.setTargetLocation(new Point(dummy.eval(DrawableUtils.outbound((Drawable)to, (Path)dummy, (boolean)false))).add(offset));
        }
    }

    private Path createRawPath(@NotNull Point begin, @NotNull Point end, @NotNull Point relative) {
        return this.control.isNull() ? super.createRawPath(begin, end) : new Elbow(begin, this.control.getRawLocation().sub(relative), end);
    }
}

