/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.draw;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationMessage;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationPool;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationProcess;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationService;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationUniverse;
import oracle.bpm.diagram.draw.ChildrenPopulator;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableCreator;
import oracle.bpm.diagram.draw.renderer.ChildrenRenderer;
import oracle.bpm.diagram.draw.renderer.DebugContainerRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.project.model.collaboration.CollaborationMessage;
import oracle.bpm.project.model.collaboration.CollaborationProcess;
import oracle.bpm.project.model.collaboration.CollaborationService;
import oracle.bpm.project.model.collaboration.CollaborationUniverse;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class CollaborationDrawableFactory
extends BpmnDrawableFactory {
    private static CollaborationDrawableFactory instance;

    public static CollaborationDrawableFactory getInstance() {
        if (instance == null) {
            instance = new CollaborationDrawableFactory();
        }
        return instance;
    }

    protected void creators() {
        this.creator(this.collaborationUniverseCreator());
        this.creator(this.collaborationServiceCreator());
        this.creator(this.collaborationProcessCreator());
        this.creator(this.collaborationMessageCreator());
        super.creators();
    }

    protected void populators() {
        this.populator(this.collaborationUniversePopulator());
        this.populator(this.collaborationProcessPopulator());
        super.populators();
    }

    protected DrawableCreator processCreator() {
        return new DrawableCreator<Process>(Process.class){

            protected Drawable create(@NotNull Drawable container, @NotNull Process process) {
                DrawableCollaborationPool drawable = new DrawableCollaborationPool(container, process);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createUnclipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                return drawable;
            }
        };
    }

    protected ChildrenPopulator processPopulator() {
        return new BpmnDrawableFactory.NodeContainerPopulator<Process>(Process.class){

            protected void append(@NotNull List<Object> result, @NotNull Process process) {
                for (Lane lane : process.getLanes()) {
                    result.add(lane);
                }
            }
        };
    }

    private DrawableCreator collaborationUniverseCreator() {
        return new DrawableCreator<CollaborationUniverse>(CollaborationUniverse.class){

            protected Drawable create(@NotNull Drawable container, @NotNull CollaborationUniverse universe) {
                DrawableCollaborationUniverse drawable = new DrawableCollaborationUniverse(container, universe);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createUnclipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                return drawable;
            }
        };
    }

    private DrawableCreator collaborationProcessCreator() {
        return new DrawableCreator<CollaborationProcess>(CollaborationProcess.class){

            protected Drawable create(@NotNull Drawable container, @NotNull CollaborationProcess process) {
                DrawableCollaborationProcess drawable = new DrawableCollaborationProcess(container, process);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                return drawable;
            }
        };
    }

    private DrawableCreator collaborationServiceCreator() {
        return new DrawableCreator<CollaborationService>(CollaborationService.class){

            protected Drawable create(@NotNull Drawable container, @NotNull CollaborationService service) {
                DrawableCollaborationService drawable = new DrawableCollaborationService(container, service);
                return drawable;
            }
        };
    }

    private DrawableCreator collaborationMessageCreator() {
        return new DrawableCreator<CollaborationMessage>(CollaborationMessage.class){

            protected Drawable create(@NotNull Drawable container, @NotNull CollaborationMessage message) {
                DrawableCollaborationMessage drawable = new DrawableCollaborationMessage(container, message);
                return drawable;
            }
        };
    }

    private ChildrenPopulator collaborationUniversePopulator() {
        return new ChildrenPopulator<CollaborationUniverse>(CollaborationUniverse.class){

            protected Iterable populate(@NotNull CollaborationUniverse element) {
                return SequenceBuilder.create(element.getEntities(), element.getMessages()).build();
            }
        };
    }

    private ChildrenPopulator collaborationProcessPopulator() {
        return new ChildrenPopulator<CollaborationProcess>(CollaborationProcess.class){

            protected Iterable populate(@NotNull CollaborationProcess element) {
                return CollectionUtils.singletonSequence(element.getBaseEntity());
            }
        };
    }
}

