/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.control;

import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.collaboration.control.CollaborationEntityController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.DomainSelectionProvider;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.draw.collaboration.CollaborationUniverseImpl;
import oracle.bpm.project.model.collaboration.CollaborationEntity;
import oracle.bpm.project.model.collaboration.CollaborationProcess;
import oracle.bpm.project.model.collaboration.CollaborationUniverse;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class PopUpCollaborationEntityCapability
extends Capability {
    public PopUpCollaborationEntityCapability(@NotNull CollaborationEntityController controller) {
        super(CapabilityType.POP_UP, (CapableController)controller);
    }

    public Command process(@NotNull CapabilityEvent event) {
        DomainSelectionProvider provider = this.getDomain().getSelectionProvider();
        provider.setSelection((Controller)this.getController());
        PopupMenu menu = this.createPopUpForEntity();
        if (menu != null) {
            MouseEvent mouse = event.getEvent();
            menu.show((UiComponent)this.getDomain().getCanvas(), mouse.getX(), mouse.getY());
        }
        return null;
    }

    @NotNull
    protected CollaborationEntityController getController() {
        return (CollaborationEntityController)super.getController();
    }

    private PopupMenu createPopUpForEntity() {
        ActionGroup result = new ActionGroup(DesignerMsg.CONVERSATION);
        result.setShowOnDisabled(false);
        result.add((BaseAction)new ShowEntityCollaborationAction(this.getController()));
        result.add((BaseAction)new RemoveEntityFromCollaborationAction(this.getController()));
        result.add((BaseAction)new GoToProcessAction(this.getController()));
        result.setSelection(DefaultSelection.createSingle((Object)this.getController().getModelObject()));
        return PopupMenu.create((UiContainer)this.getDomain().getCanvas(), (ActionGroup)result);
    }

    private static class ShowEntityCollaborationAction
    extends CollaborationAction {
        private ShowEntityCollaborationAction(@NotNull CollaborationEntityController<?> controller) {
            super(controller, DesignerMsg.SHOW_COLLABORATION);
        }

        public void run() {
            CollaborationUniverse universe = this.getUniverse();
            if (universe != null) {
                universe.extend((CollaborationProcess)this.getController().getModelObject());
            }
            this.updateController();
        }

        protected void updateEnableStatus(Selection selection) {
            CollaborationEntity entity = (CollaborationEntity)this.getController().getModelObject();
            this.setEnabled(entity instanceof CollaborationProcess && this.getUniverse().isExtendable((CollaborationProcess)this.getController().getModelObject()));
        }
    }

    private static class RemoveEntityFromCollaborationAction
    extends CollaborationAction {
        private RemoveEntityFromCollaborationAction(@NotNull CollaborationEntityController<?> controller) {
            super(controller, DesignerMsg.HIDE_COLLABORATION);
        }

        public void run() {
            CollaborationUniverse universe = this.getUniverse();
            if (universe != null) {
                universe.detach((CollaborationEntity)this.getController().getModelObject());
            }
            this.updateController();
        }

        protected void updateEnableStatus(Selection selection) {
            this.setEnabled(!this.getUniverse().getMainEntity().equals(this.getController().getModelObject()));
        }
    }

    private static class GoToProcessAction
    extends CollaborationAction {
        private GoToProcessAction(@NotNull CollaborationEntityController<?> controller) {
            super(controller, DesignerMsg.OPEN_EDITOR);
        }

        public void run() {
            CollaborationEntity entity = (CollaborationEntity)this.getController().getModelObject();
            AbstractStudioWorkbench.getInstance().openEditorForObject(entity.getBaseEntity());
        }

        protected void updateEnableStatus(Selection selection) {
            Object input = AbstractStudioWorkbench.getInstance().getActiveEditor().getInput();
            CollaborationProcess collaborationProcess = null;
            if (input instanceof CollaborationUniverseImpl) {
                collaborationProcess = ((CollaborationUniverseImpl)input).getMainEntity();
            }
            this.setEnabled(this.getController().getModelObject() instanceof CollaborationProcess && !((CollaborationEntity)this.getController().getModelObject()).equals(collaborationProcess));
        }
    }

    private static abstract class CollaborationAction
    extends BaseAction {
        private final CollaborationEntityController<?> controller;

        private CollaborationAction(@NotNull CollaborationEntityController<?> controller, @NotNull Msg message) {
            super(message);
            this.requires(CollaborationEntity.class);
            this.controller = controller;
        }

        protected void updateController() {
            this.getController().getContainer().refresh();
            this.getController().getDomain().getCanvas().revalidate();
            this.getController().getDomain().getCanvas().repaint();
        }

        protected CollaborationUniverse getUniverse() {
            CollaborationUniverse result = null;
            Controller container = this.controller.getContainer();
            if (container.getModelObject() instanceof CollaborationUniverse) {
                result = (CollaborationUniverse)container.getModelObject();
            }
            return result;
        }

        protected CollaborationEntityController<?> getController() {
            return this.controller;
        }
    }
}

