/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.collaboration.control;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import oracle.bpm.command.Command;
import oracle.bpm.designer.collaboration.control.CollaborationEntityController;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationEntity;
import oracle.bpm.designer.collaboration.draw.DrawableCollaborationUniverse;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.animation.Animation;
import oracle.bpm.diagram.editor.animation.AnimationBuilder;
import oracle.bpm.diagram.editor.animation.AnimatorEasing;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;

public class DragCollaborationEntityCapability
extends DraggableCapability {
    private Point distance;
    private NavigableMap<Integer, Drawable> entities;
    private Point location;

    public DragCollaborationEntityCapability(@NotNull CollaborationEntityController controller) {
        super((CapableController)controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.entities = new TreeMap<Integer, Drawable>();
        for (Drawable child : this.getDrawableUniverse().getOrderedEntities()) {
            this.entities.put(child.getLocation().getY(), child);
        }
        DrawableCollaborationEntity entity = this.getController().getDrawableObject();
        this.distance = event.getLocation().sub(entity.getLocation());
        this.location = entity.getLocation();
    }

    public void drag(@NotNull CapabilityEvent event) {
        Map.Entry<Integer, Drawable> swap;
        DrawableCollaborationEntity entity = this.getController().getDrawableObject();
        int y = event.getLocation().sub(this.distance).getY();
        entity.setLocation(new Point(entity.getLocation().getX(), y));
        boolean down = this.location.sub(event.getLocation()).getY() < 0;
        Map.Entry<Integer, Drawable> entry = swap = down ? this.entities.higherEntry(this.location.getY()) : this.entities.lowerEntry(this.location.getY());
        if (swap != null && !swap.getValue().equals((Object)entity) && (down && swap.getKey() < y || !down && swap.getKey() > y)) {
            this.swap(swap, down);
        }
        this.getDrawableUniverse().refreshDrawableMessages();
        this.getDomain().getCanvas().repaint();
    }

    public void endDrag(@NotNull CapabilityEvent event) {
        DrawableCollaborationEntity drawable = this.getController().getDrawableObject();
        this.move((Drawable)drawable, this.location);
    }

    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    @NotNull
    protected CollaborationEntityController getController() {
        return (CollaborationEntityController)super.getController();
    }

    private void swap(Map.Entry<Integer, Drawable> swap, boolean down) {
        Drawable original = (Drawable)this.entities.get(this.location.getY());
        Drawable other = swap.getValue();
        int heightDelta = (original.getHeight() - other.getHeight()) / 2 * (down ? -1 : 1);
        this.entities.remove(swap.getKey());
        this.entities.remove(this.location.getY());
        int originalUpdatedY = swap.getKey() + heightDelta;
        int otherUpdatedY = this.location.getY() + heightDelta;
        this.entities.put(originalUpdatedY, original);
        this.entities.put(otherUpdatedY, other);
        this.move(other, new Point(other.getLocation().getX(), otherUpdatedY));
        this.location = new Point(this.location.getX(), originalUpdatedY);
        this.getDrawableUniverse().swapEntities(original, swap.getValue());
    }

    private void move(@NotNull Drawable drawable, @NotNull Point location) {
        Animation messages = new Animation(){

            public void interpolate(@NotNull Drawable drawable, float percentage) {
                DragCollaborationEntityCapability.this.getDrawableUniverse().refreshDrawableMessages();
            }
        };
        AnimationBuilder.create((Drawable)drawable).easing(AnimatorEasing.BOUNCE_OUT).slower().animate(Animation.translate((Point)drawable.getLocation(), (Point)location)).animate(messages).animate(Animation.repaint((Domain)this.getDomain())).start();
    }

    private DrawableCollaborationUniverse getDrawableUniverse() {
        return (DrawableCollaborationUniverse)this.getController().getDrawableObject().getContainer();
    }
}

